\name{reformat_code}
\alias{reformat_code}
\title{Format the code in the usage and examples sections.}
\usage{reformat_code(path, section = c("examples", "usage"), 
    ...)
}
\description{Format the code in the usage and examples sections.}
\details{This function can polish the Rd files generated by roxygen mainly in two
sections: usage and examples. By default, roxygen will omit the spaces and
indent in the code, which makes the code (especially in the examples section)
hard to read.}
\value{NULL (the original Rd file gets updated)}
\author{Yihui Xie <\url{http://yihui.name}>}
\arguments{\item{path}{the path of the Rd file}
\item{section}{the sections in the Rd file to (re)format}
\item{...}{other arguments passed to \code{tidy.source}}
}
\examples{\dontrun{
    rd.file = system.file("examples", "reformat_code_demo.Rd", 
        package = "Rd2roxygen")
    file.copy(rd.file, tempdir())
    fmt.file = file.path(tempdir(), "reformat_code_demo.Rd")
    file.show(fmt.file)
    reformat_code(fmt.file)
    file.show(fmt.file)
}}

