% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LLTSA.R
\name{do.lltsa}
\alias{do.lltsa}
\title{Linear Local Tangent Space Alignment}
\usage{
do.lltsa(X, ndim = 2, type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Linear Local Tangent Space Alignment (LLTSA) is a linear variant of the
celebrated LTSA method. It uses the tangent space in the neighborhood for each data point
to represent the local geometry. Alignment of those local tangent spaces in the low-dimensional space
returns an explicit mapping from the high-dimensional space.
}
\examples{
\dontrun{
## generate data
X <- aux.gensamples()

## try different neighborhood size
out1 <- do.lltsa(X, type=c("proportion",0.01))
out2 <- do.lltsa(X, type=c("proportion",0.05))
out3 <- do.lltsa(X, type=c("proportion",0.10))

## Visualize three different projections
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="LLTSA::1\% connected")
plot(out2$Y[,1],out2$Y[,2],main="LLTSA::5\% connected")
plot(out3$Y[,1],out3$Y[,2],main="LLTSA::10\% connected")
}

}
\references{
\insertRef{zhang_linear_2007}{Rdimtools}
}
\seealso{
\code{\link{do.ltsa}}
}
\author{
Kisung You
}
