% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mle2.R
\name{est.mle2}
\alias{est.mle2}
\title{Maximum Likelihood Esimation with Poisson Process and Bias Correction}
\usage{
est.mle2(X, k1 = 10, k2 = 20)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k1}{minimum neighborhood size, larger than 1.}

\item{k2}{maximum neighborhood size, smaller than \eqn{n}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Authors argue that the approach proposed in \code{\link{est.mle1}} is
empirically bias-prone in that the averaging of sample statistics over
all data points is taken to be a harmonic manner.
}
\examples{
\dontrun{
## create example data sets with intrinsic dimension 2
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.mle2(X1)
out2 = est.mle2(X2)
out3 = est.mle2(X3)

sprintf("* est.mle2 : estimated dimension for 'swiss'  data is \%.2f.",out1$estdim)
sprintf("* est.mle2 : estimated dimension for 'ribbon' data is \%.2f.",out2$estdim)
sprintf("* est.mle2 : estimated dimension for 'saddle' data is \%.2f.",out3$estdim)
}
}
\references{
\insertRef{mackay_comments_2005}{Rdimtools}
}
\author{
Kisung You
}
