% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegSDCgen.R
\encoding{UTF8}
\name{RegSDCgen}
\alias{RegSDCgen}
\title{Regression-based SDC Tools - General data generation}
\usage{
RegSDCgen(
  y,
  x = NULL,
  doSVD = FALSE,
  yNew = NULL,
  lambda = Inf,
  makeunique = TRUE,
  ensureIntercept = TRUE,
  returnParts = FALSE
)
}
\arguments{
\item{y}{Matrix of confidential variables}

\item{x}{Matrix of non-confidential variables}

\item{doSVD}{SVD when TRUE and QR when FALSE}

\item{yNew}{Matrix of y-data for new scores (simulated when NULL)}

\item{lambda}{ROMM parameter}

\item{makeunique}{Parameter to be used in GenQR}

\item{ensureIntercept}{Whether to ensure/include a constant term. Non-NULL x is subjected to \code{\link{EnsureIntercept}}}

\item{returnParts}{Alternative output two matrices: yHat (fitted) and yRes (generated residuals).}
}
\value{
Generated version of y
}
\description{
IPSO by QR or SVD, scores from arbitrary data, and ROMM
}
\details{
doSVD has effect on decomposition of y and yNew. Input matrices are subjected to \code{\link{EnsureMatrix}}.
}
\examples{
exY <- matrix(rnorm(15), 5, 3)
RegSDCgen(exY)
RegSDCgen(exY, yNew = exY + 0.001 * matrix(rnorm(15), 5, 3))  # Close to exY
RegSDCgen(exY, lambda = 0.001)  # Close to exY
}
\author{
Øyvind Langsrud
}
\keyword{internal}
