/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTextSpacing;
import org.docx4j.dml.CTTextSpacingPoint;
import org.docx4j.dml.STTextAlignType;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;

public class ParProperties {
    private String textalign;
    private int paddingbottom;
    private int paddingtop;
    private int paddingleft;
    private int paddingright;

    public String getTextalign() {
        return this.textalign;
    }

    public int getPaddingbottom() {
        return this.paddingbottom;
    }

    public int getPaddingtop() {
        return this.paddingtop;
    }

    public int getPaddingleft() {
        return this.paddingleft;
    }

    public int getPaddingright() {
        return this.paddingright;
    }

    public ParProperties(String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) {
        this.textalign = textalign;
        this.paddingbottom = paddingbottom;
        this.paddingtop = paddingtop;
        this.paddingleft = paddingleft;
        this.paddingright = paddingright;
    }

    public PPr get_docx_pp() {
        PPr parProperties = new PPr();
        Jc alignment = new Jc();
        if (this.textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (this.textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (this.textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (this.textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        parProperties.setJc(alignment);
        PPrBase.Spacing space = new PPrBase.Spacing();
        space.setBefore(BigInteger.valueOf((long)this.paddingtop * 20L));
        space.setAfter(BigInteger.valueOf((long)this.paddingbottom * 20L));
        parProperties.setSpacing(space);
        PPrBase.Ind padding = new PPrBase.Ind();
        padding.setLeft(BigInteger.valueOf((long)this.paddingleft * 20L));
        padding.setRight(BigInteger.valueOf((long)this.paddingright * 20L));
        parProperties.setInd(padding);
        return parProperties;
    }

    public CTTextParagraphProperties get_pptx_pp() {
        CTTextParagraphProperties parProperties = new CTTextParagraphProperties();
        if (this.textalign.equals("left")) {
            parProperties.setAlgn(STTextAlignType.L);
        } else if (this.textalign.equals("center")) {
            parProperties.setAlgn(STTextAlignType.CTR);
        } else if (this.textalign.equals("right")) {
            parProperties.setAlgn(STTextAlignType.R);
        } else if (this.textalign.equals("justify")) {
            parProperties.setAlgn(STTextAlignType.JUST);
        }
        CTTextSpacing spaceafter = new CTTextSpacing();
        CTTextSpacingPoint pointafter = new CTTextSpacingPoint();
        pointafter.setVal(this.paddingbottom * 100);
        spaceafter.setSpcPts(pointafter);
        parProperties.setSpcAft(spaceafter);
        CTTextSpacing spacebefore = new CTTextSpacing();
        CTTextSpacingPoint pointbefore = new CTTextSpacingPoint();
        pointbefore.setVal(this.paddingtop * 100);
        spacebefore.setSpcPts(pointbefore);
        parProperties.setSpcBef(spacebefore);
        parProperties.setMarL(Integer.valueOf(this.paddingleft * 12700));
        parProperties.setMarR(Integer.valueOf(this.paddingleft * 12700));
        return parProperties;
    }

    public LinkedHashMap<String, String> get_html_pp() {
        LinkedHashMap<String, String> parProperties = new LinkedHashMap<String, String>();
        if (this.textalign.equals("left")) {
            parProperties.put("text-align", "left");
        } else if (this.textalign.equals("center")) {
            parProperties.put("text-align", "center");
        } else if (this.textalign.equals("right")) {
            parProperties.put("text-align", "right");
        } else if (this.textalign.equals("justify")) {
            parProperties.put("text-align", "justify");
        } else {
            parProperties.put("text-align", "left");
        }
        parProperties.put("margin-top", String.valueOf(this.paddingtop) + "px");
        parProperties.put("margin-bottom", String.valueOf(this.paddingbottom) + "px");
        parProperties.put("margin-right", String.valueOf(this.paddingright) + "px");
        parProperties.put("margin-left", String.valueOf(this.paddingleft) + "px");
        return parProperties;
    }
}

