package org.lysis.reporters.html4r.elements;

import java.util.LinkedHashMap;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class Iframe implements HTML4R {

	private int height;
	private int width;
	private boolean seamless;
	private String src;
	private ParProperties parProperties;
	
	public Iframe(int w, int h, boolean seamless, String src, ParProperties pp){
		height = h;
		width = w;
		this.seamless = seamless;
		this.src = src;
		parProperties = pp;
	}
	@Override
	public String getHTML() {
		String out = "";
		LinkedHashMap<String, String> ppr = parProperties.get_html_pp();
		String pStart = "<p style=\"" + Format.getJSString(ppr) + "\">";
		String pStop = "</p>";
		
		out += pStart + "<iframe src=\"" + src + "\" width=\"" + width + "\" height=\"" + height + "\" ";
		if( seamless ) out += "seamless";
		out += ">" + "</iframe>" + pStop;
		return out;
	}

	@Override
	public String getCSS() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getJS() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasJS() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		// TODO Auto-generated method stub
		return false;
	}

}
