% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/addDate.pptx.R
\name{addDate.pptx}
\alias{addDate.pptx}
\title{Insert a date shape into a document pptx object}
\usage{
\method{addDate}{pptx}(doc, value, str.format = "\%Y-\%m-\%d", ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{character value to add into the date
shape of the current slide. optionnal. If missing
current date will be used.}

\item{str.format}{character value to use to format
current date (if \code{value} is missing).}

\item{...}{further arguments, not used.}
}
\value{
a document object
}
\description{
Insert a date into the current slide of a \code{pptx} object.
}
\examples{
\dontrun{
doc.filename = "addDate_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )
doc = addSlide( doc, slide.layout = "Title Slide" )
#set the main title
doc = addTitle( doc, "Presentation title" ) 
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")

## add a date on the current slide
doc = addDate( doc )


doc = addSlide( doc, slide.layout = "Title and Content" )
## add a page number on the current slide but not 
## the default text (slide number)
doc = addDate( doc, "Dummy date" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addFooter.pptx}}, \code{\link{addPageNumber.pptx}}
, \code{\link{strptime}},  \code{\link{addDate}}
}

