/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.List;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.XsltCommonFunctions;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.convert.out.html.HTMLExporterVisitorGenerator;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.convert.out.html.HtmlScriptHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLExporterVisitorDelegate
extends AbstractVisitorExporterDelegate<HTMLSettings, HTMLConversionContext> {
    protected HTMLExporterVisitorDelegate() {
        super(HTMLExporterVisitorGenerator.GENERATOR_FACTORY);
    }

    @Override
    protected Element createDocumentRoot(HTMLConversionContext conversionContext, Document document) throws Docx4JException {
        return document.createElement("html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendDocumentHeader(HTMLConversionContext conversionContext, Document document, Element documentRoot) throws Docx4JException {
        Element headEl = document.createElement("head");
        Element meta = document.createElement("meta");
        Element element = null;
        StringBuilder buffer = new StringBuilder(10240);
        String userCSS = conversionContext.getUserCSS();
        String userScript = conversionContext.getUserScript();
        boolean hasDefaultHeader = false;
        boolean hasDefaultFooter = false;
        documentRoot.appendChild(headEl);
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html; charset=utf-8");
        headEl.appendChild(meta);
        try {
            conversionContext.getSections().next();
            hasDefaultHeader = XsltCommonFunctions.hasDefaultHeader(conversionContext);
            hasDefaultFooter = XsltCommonFunctions.hasDefaultHeader(conversionContext);
        }
        finally {
            conversionContext.getSections().start();
        }
        HtmlCssHelper.createDefaultCss(hasDefaultHeader, hasDefaultFooter, buffer);
        HtmlCssHelper.createCssForStyles(conversionContext.getWmlPackage(), conversionContext.getStyleTree(), buffer);
        if (userCSS != null && userCSS.length() > 0) {
            buffer.append(userCSS);
        }
        if ((element = conversionContext.createStyleElement(document, buffer.toString())) != null) {
            headEl.appendChild(element);
        }
        buffer.setLength(0);
        HtmlScriptHelper.createDefaultScript(buffer);
        if (userScript != null && userScript.length() > 0) {
            buffer.append(userScript);
        }
        if ((element = conversionContext.createScriptElement(document, buffer.toString())) != null) {
            headEl.appendChild(element);
        }
    }

    @Override
    protected Element createDocumentBody(HTMLConversionContext conversionContext, Document document, Element documentRoot) {
        return document.createElement("body");
    }

    @Override
    protected Element createSectionRoot(HTMLConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        return null;
    }

    @Override
    protected void appendSectionHeader(HTMLConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        if (XsltCommonFunctions.hasDefaultHeader(conversionContext)) {
            this.appendPartContent(conversionContext, document, sectionWrapper, currentParent, "header", sectionWrapper.getHeaderFooterPolicy().getDefaultHeader(), ((Hdr)sectionWrapper.getHeaderFooterPolicy().getDefaultHeader().getJaxbElement()).getContent());
        }
    }

    @Override
    protected Element createSectionBody(HTMLConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        Element div = document.createElement("div");
        div.setAttribute("class", "document");
        return div;
    }

    @Override
    protected void appendSectionFooter(HTMLConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        if (XsltCommonFunctions.hasDefaultFooter(conversionContext)) {
            this.appendPartContent(conversionContext, document, sectionWrapper, currentParent, "footer", sectionWrapper.getHeaderFooterPolicy().getDefaultFooter(), ((Ftr)sectionWrapper.getHeaderFooterPolicy().getDefaultFooter().getJaxbElement()).getContent());
        }
    }

    protected void appendPartContent(HTMLConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent, String className, Part part, List<Object> content) throws Docx4JException {
        Element div = document.createElement("div");
        currentParent.appendChild(div);
        div.setAttribute("class", className);
        this.appendPartContent(conversionContext, document, part, content, div);
    }

    @Override
    protected void appendDocumentFooter(HTMLConversionContext conversionContext, Document document, Element documentRoot) throws Docx4JException {
        MainDocumentPart mainDocumentPart = conversionContext.getWmlPackage().getMainDocumentPart();
        if (mainDocumentPart.hasFootnotesPart()) {
            this.appendFootnotesEndnotes(conversionContext, document, documentRoot, "footnotes", mainDocumentPart.getFootnotesPart(), ((CTFootnotes)mainDocumentPart.getFootnotesPart().getJaxbElement()).getFootnote());
        }
        if (mainDocumentPart.hasEndnotesPart()) {
            this.appendFootnotesEndnotes(conversionContext, document, documentRoot, "endnotes", mainDocumentPart.getEndNotesPart(), ((CTEndnotes)mainDocumentPart.getEndNotesPart().getJaxbElement()).getEndnote());
        }
    }

    protected void appendFootnotesEndnotes(HTMLConversionContext conversionContext, Document document, Element documentRoot, String string, Part part, List<CTFtnEdn> ftnEdnList) {
    }
}

