/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j;

import org.pptx4j.Point;

public class Box {
    Point offset;
    Point extent;

    public Box(long offsetX, long offsetY, long extentX, long extentY) {
        this.offset = new Point(offsetX, offsetY);
        this.extent = new Point(extentX, extentY);
        System.out.println(this.debug());
    }

    public void flipH() {
        this.offset.x += this.extent.x;
        this.extent.x = -this.extent.x;
        System.out.println("FlipH--> " + this.debug());
    }

    public void flipV() {
        this.offset.y += this.extent.y;
        this.extent.y = -this.extent.y;
        System.out.println("FlipV--> " + this.debug());
    }

    public Point getOtherCorner() {
        return this.offset.add(this.extent);
    }

    public void toPixels() {
        this.offset = this.offset.toPixels();
        this.extent = this.extent.toPixels();
    }

    public void rotate(int units) {
        Point offsetDash3;
        Point centre = new Point(Math.round((float)this.offset.x + 0.5f * (float)this.extent.x), Math.round((float)this.offset.y + 0.5f * (float)this.extent.y));
        float degree = -units / 60000;
        System.out.println("Rotating " + degree);
        float radians = (float)Math.toRadians(degree);
        Point otherCorner = this.getOtherCorner();
        Point otherCornerDash = otherCorner.subtract(centre);
        Point otherCornerDash2 = this.rotate(otherCornerDash, radians);
        Point otherCornerDash3 = otherCornerDash2.add(centre);
        Point offsetDash = this.offset.subtract(centre);
        Point offsetDash2 = this.rotate(offsetDash, radians);
        this.offset = offsetDash3 = offsetDash2.add(centre);
        this.extent = otherCornerDash3.subtract(this.offset);
        System.out.println("Rotated--> " + this.debug());
    }

    private Point rotate(Point p, float radians) {
        long xDash = Math.round((double)p.x * Math.cos(radians) - (double)p.y * Math.sin(radians));
        long yDash = Math.round((double)p.x * Math.sin(radians) + (double)p.y * Math.cos(radians));
        return new Point(xDash, yDash);
    }

    public String debug() {
        return "offset " + this.offset.debug() + "; extent " + this.extent.debug();
    }

    public Point getOffset() {
        return this.offset;
    }

    public Point getExtent() {
        return this.extent;
    }

    public static void main(String[] args) {
        Box b = new Box(0L, 0L, 1L, 0L);
        b.rotate(5400000);
        System.out.println();
    }
}

