/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml.esc;

import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import java.io.IOException;
import java.io.Writer;

abstract class XMLEscapeWriterBase
implements XMLEscapeWriter {
    private final String encoding;
    final Writer w;

    XMLEscapeWriterBase(Writer writer, String encoding) {
        if (writer == null) {
            throw new NullPointerException("Cannot construct XML escape for null writer.");
        }
        this.w = writer;
        this.encoding = encoding;
    }

    public final void writeAttValue(String value) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        this.writeAttValue(value.toCharArray(), 0, value.length());
    }

    public final void writeText(String value) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        this.writeText(value.toCharArray(), 0, value.length());
    }

    public void writeText(char[] ch, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.writeText(ch[i]);
        }
    }

    public final String getEncoding() {
        return this.encoding;
    }
}

