% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_igraph.R
\name{ResIN_igraph}
\alias{ResIN_igraph}
\title{ResIN_igraph}
\usage{
ResIN_igraph(
  df,
  node_vars = NULL,
  cor_method = "auto",
  weights = NULL,
  method_wCorr = "Polychoric",
  remove_negative = TRUE,
  igraph_arglist = NULL,
  EBICglasso = FALSE,
  EBICglasso_arglist = NULL,
  cluster = TRUE,
  seed = 42
)
}
\arguments{
\item{df}{A data-frame object containing the raw data.}

\item{node_vars}{An optional character string detailing the attitude item columns to be selected for ResIN analysis (i.e. the subset of attitude variables in df).}

\item{cor_method}{Which correlation method should be used? Defaults to "auto" which applies the \code{cor_auto} function from the \code{qgraph} package. Possible arguments are \code{"auto"}, \code{"pearson"}, \code{"kendall"}, and \code{"spearman"}.}

\item{weights}{An optional continuous vector of survey weights. Should have the same length as number of observations in df. If weights are provided, weighted correlation matrix will be estimated with the \code{weightedCorr} function from the \code{wCorr} package.}

\item{method_wCorr}{If weights are supplied, which method for weighted correlations should be used? Defaults to \code{"Polychoric"}. See \code{wCorr::weightedCorr} for all correlation options.}

\item{remove_negative}{Should all negative correlations be removed? Defaults to TRUE (highly recommended). Setting to FALSE makes it impossible to estimate a force-directed network layout. Function will use igraph::layout_nicely instead.}

\item{igraph_arglist}{An optional argument list feeding additional instructions to \code{igraph}. Needs to be specified as an object list containing the arguments to be passed down.}

\item{EBICglasso}{Should a sparse, Gaussian-LASSO ResIN network be estimated? Defaults to FALSE. If set to TRUE, \code{EBICglasso} function from the \code{qgraph} packages performs regularization on (nearest positive-semi-definite) ResIN correlation matrix.}

\item{EBICglasso_arglist}{An argument list feeding additional instructions to the \code{EBICglasso} function if \code{EBICglasso} is set to TRUE.}

\item{cluster}{Optional, should community detection be performed on item response network? Defaults to FALSE. If set to TRUE, performs "cluster_leading_eigen" function from the igraph package and stores results in plotting_frame.}

\item{seed}{Random seed for force-directed algorithm.}
}
\value{
A list object containing the \code{igraph} output object, a numeric vector detailing which item responses belong to which item (\code{same_items}), and optionally a matrix detailing community membership of different item nodes (\code{clustering}).
}
\description{
Performs Response Item-Network analysis (ResIN) and exports the results as an \code{igraph} object.
}
\examples{

## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Run the function:
\donttest{
ResIN_igraph <-  ResIN_igraph(lik_data)


## Plot and/or investigate as you wish:
igraph::plot.igraph(ResIN_igraph$igraph_obj)
}

}
\references{
Csardi G, Nepusz T (2006). “The igraph software package for complex network research.” InterJournal, Complex Systems, 1695. https://igraph.org.
}
