% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Request.R
\docType{data}
\name{Request}
\alias{Request}
\title{Creates request object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Called internally for handling incoming requests from Rserve side.
Also useful for testing.
}
\section{Construction}{
\preformatted{Request$new(path = "/",
 method = c("GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE", "PATCH"),
 parameters_query = list(),
 parameters_body = list(),
 headers = list(),
 body = list(),
 cookies = list(),
 content_type = "text/plain",
 decode = NULL,
 ...)
}
\itemize{
\item \strong{\code{path}} :: \code{character(1)}\cr
Character with requested path. Always starts with \code{/}.
\item \strong{\code{method}} :: \code{character(1)}\cr
Request HTTP method.
\item \strong{\code{parameters_path}} :: \code{named list()}\cr
List of parameters extracted from templated path after routing.
For example if we have some handler listening at \code{/job/{job_id}} and we are
receiving request at \code{/job/1} then \code{parameters_path} will be \code{list(job_id = "1")}.
It is important to understand that \code{parameters_path} will be available
(not empty) only after request will reach handler.
This effectively means that \code{parameters_path} can be used inside handler
and response middleware (but not request middleware!).
\item \strong{\code{parameters_query}} :: \code{named list()}\cr
A named list with URL decoded query parameters.
\item \strong{\code{parameters_body}} :: \code{named list()}\cr
A named list with URL decoded body parameters. This field is helpful when request is
a urlencoded form or a multipart form.
\item \strong{\code{headers}} :: \code{named list()}\cr
Request HTTP headers represented as named list.
\item \strong{\code{body}} :: \code{anything} \cr
Request body. Can be anything and in conjunction with \code{content_type}
defines how HTTP body will be represented.
\item \strong{\code{cookies}} :: \code{named list()}\cr
cookies represented as named list. \strong{Note} that cookies should be provided explicitly -
they won't be derived from \code{headers}.
\item \strong{\code{content_type}} :: \code{character(1)}\cr
HTTP content type. \strong{Note} that \code{content_type} should be provided explicitly -
it won't be derived from \code{headers}.
\item \strong{\code{decode}} :: \code{function}\cr
Function to decode body for the specific content type.
}
}

\section{Fields}{

\itemize{
\item \strong{\code{path}} :: \code{character(1)}\cr
Request path.
\item \strong{\code{method}} :: \code{character(1)}\cr
Request HTTP method.
\item \strong{\code{headers}} :: \code{named list()}\cr
Request headers.
\item \strong{\code{parameters_query}} :: \code{named list()}\cr
Request query parameters.
\item \strong{\code{parameters_body}} :: \code{named list()}\cr
Request body parameters.
\item \strong{\code{content_type}} :: \code{character(1)}\cr
Request body content type.
\item \strong{\code{body}} :: \code{raw()} | \code{named character()}\cr
Request body.
\item \strong{\code{cookies}} :: \code{named list()}\cr
Request cookies.
\item \strong{\code{files}} :: \code{named list()}\cr
Structure which contains positions and lengths of files for the multipart
body.
\item \strong{\code{context}} :: \code{environment()}\cr
Environment to store any data. Can be used in middlewares.
\item \strong{\code{id}} :: \code{character(1)}\cr
Automatically generated UUID for each request. Read only.
\item \strong{\code{date}} :: \code{POSIXct(1)}\cr
Request \code{Date} header converted to \code{POSIXct}.
\item \strong{\code{accept}} :: \code{character()}\cr
Split \code{Accept} request header.
\item \strong{\code{accept_json}} :: \code{logical(1)}\cr
Request accepts JSON response.
\item \strong{\code{accept_xml}} :: \code{logical(1)}\cr
Request accepts XML response.
}
}

\section{Methods}{

\itemize{
\item \strong{\code{reset}}\code{()}\cr
Resets request object. This is not useful for end user, but useful for RestRserve internals -
resetting R6 class is much faster then initialize it.
\item \strong{\code{get_header}}\code{(name, default = NULL)}\cr
\code{character(1)}, \code{character(1)} -> \code{character()}\cr
Get HTTP response header value. If requested header is empty returns \code{default}.
\item \strong{\code{get_param_query}}\code{(name)}\cr
\code{character(1)} -> \code{character(1)}\cr
Get request query parameter by name.
\item \strong{\code{get_param_body}}\code{(name)}\cr
\code{character(1)} -> \code{character(1)}\cr
Get request body parameter by name.
\item \strong{\code{get_param_path}}\code{(name)}\cr
\code{character(1)} -> \code{character(1)}\cr
Get templated path parameter by name.
\item \strong{\code{get_file}}\code{(name)}\cr
\code{character(1)} -> \code{raw()}\cr
Extract specific file from multipart body.
}
}

\examples{
# init simply request
rq = Request$new(
  path = "/",
  parameters_query = list(
    "param1" = "value1",
    "param2" = "value2"
  ),
  headers = list(
    "Content-encoding" = "identity",
    "Custom-field" = "value"
  ),
  cookies = list(
    "sessionId" = "1"
  )
)
# get request UUID
rq$id
# get content accept
rq$accept
# get request content type
rq$content_type
# get header by name (lower case)
rq$get_header("custom-field")
# get query param by name
rq$get_param_query("param1")
# print request
rq

}
\seealso{
\link{Response} \link{Application}
}
\keyword{datasets}
