% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_REDCap.R
\name{shiny_widget_translation}
\alias{shiny_widget_translation}
\alias{shinyREDCap_textInput}
\alias{shinyREDCap_dateInput}
\alias{shinyREDCap_dropdown}
\alias{shinyREDCap_truefalse}
\alias{shinyREDCap_yesno}
\alias{shinyREDCap_radio}
\alias{shinyREDCap_checkbox}
\alias{shinyREDCap_notes}
\alias{shinyREDCap_integer}
\title{Shiny Widget Translation}
\usage{
shinyREDCap_textInput(id, field_label, value = NULL, placeholder = NULL, ...)

shinyREDCap_dateInput(id, field_label, value = NULL, ...)

shinyREDCap_dropdown(id, field_label, required, choices, value = NULL, ...)

shinyREDCap_truefalse(id, field_label, required, value = NULL, ...)

shinyREDCap_yesno(id, field_label, required, value = NULL, ...)

shinyREDCap_radio(id, field_label, required, choices, value = NULL, ...)

shinyREDCap_checkbox(id, field_label, choices, value = NULL, ...)

shinyREDCap_notes(id, field_label, value = NULL, ...)

shinyREDCap_integer(id, field_label, value = NULL, ...)
}
\arguments{
\item{id}{A string, containing a globally unique REDCap question identifier. Used to
create a valid Shiny inputID.}

\item{field_label}{A string containing the question being asked. May contain
html formatting.}

\item{value}{Default value or previous data if question has previously been answered}

\item{placeholder}{Placeholder text to help a reviewer decide how to answer the question}

\item{...}{Any additional parameters to pass to shiny widget inputs.}

\item{required}{A string, "yes" or "no". Is this a required REDCap question type?}

\item{choices}{REDCap choices for the question.}
}
\value{
A shiny input widget for the UI
}
\description{
A collection of functions to map REDCap question types as exported by the REDCap API
to native Shiny widgets.
}
\keyword{internal}
