\name{track.fasta-constructors}
\alias{track.fasta-constructors}
\alias{track.fasta.multi}
\alias{track.fasta.collection}
\title{
  Track constructors for FASTA files
}

\description{
  Produces \code{\linkS4class{sliceable}}-inheriting objects to query "in situ" FASTA files.
  
  \code{track.fasta.multi} is designed to handle a single multi-FASTA file aggregating all the chromosomes of an organism. An index as generated by the HTSlib (formerly "SAMtools") \code{faidx} command is required.
  
  \code{track.fasta.collection} is designed to handle a collection of standard FASTA files, one per chromosome.
}

\usage{
  track.fasta.multi(fastaFile, indexFile, .name, .organism, .assembly,
    .parameters, warn = TRUE)
  track.fasta.collection(files, chromosomes, .name, .organism, .assembly,
    .parameters, warn = TRUE)
}

\arguments{
  \item{fastaFile}{
    Single character value, the file name and path to a multi-FASTA file (.fa) to build a track upon.
  }
  \item{indexFile}{
    Single character value, the file name and path to a multi-FASTA index file (.fai) corresponding to \code{fastaFile}. This index file is supposd to be produced by the \code{faidx} command from SAMtools.
  }
  \item{.name}{
    Single character value, to fill the \code{name} field inherited from \code{\linkS4class{drawable}}.
  }
  \item{.organism}{
    Single character value, to fill the \code{organism} field of the object.
  }
  \item{.assembly}{
    Single character value, to fill the \code{assembly} field of the object.
  }
  \item{.parameters}{
    A \code{list} of drawing parameters, to fill the \code{parameters} field of the object.
  }
  \item{warn}{
    Single logical value, to be passed to the appropriate \code{check} method. Other conversion warnings rely on this value too in \code{track.table}.
  }
  \item{files}{
    Character vector, file names and paths to multiple single-FASTA file (.fa) to build a track upon (one per chromosome).
  }
  \item{chromosomes}{
    Character vector, chromosomes names to attribute to each file in \code{files}.
  }
}

\details{
  Both functions suppose the FASTA files to respect the following :
  \itemize{
    \item{They begin with a single line of comment, after a '>' sign.}
    \item{All sequence lines have the same length (whatever it is).}
    \item{The line separator (\\n, \\r\\n) is always the same in a file.}
    \item{No empty line.}
  }
  
  Returned sequences may be wrong (without error or notice !) if any of these is not fullfilled. Standard sources (see below) usually enforce these conditions.
}

\value{
  An object of class \code{\linkS4class{track.fasta}}.
}

\references{
  Example of FASTA file collection (human assembly 'hg19'), from UCSC : \url{http://hgdownload.soe.ucsc.edu/goldenPath/hg19/bigZips/chromFa.tar.gz}
  
  Example of single multi-FASTA file (human assembly 'hg19'), from 1000 genomes : \url{ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/human_g1k_v37.fasta.gz}
  
  The \href{http://www.htslib.org/doc/faidx.html}{faidx} documentation, from the HTSlib project.
}

\author{
  Sylvain Mareschal
}

\seealso{
  \code{\link{track-constructors}}, \code{\link{Annotation}}
  
  \code{\link{tk.browse}}, \code{\link{browsePlot}}
}

