% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_weightfunction}
\alias{prior_weightfunction}
\title{Creates a prior distribution for a weight function}
\usage{
prior_weightfunction(distribution, parameters, prior_weights = 1)
}
\arguments{
\item{distribution}{name of the prior distribution. The
possible options are
\describe{
\item{\code{"two.sided"}}{for a two-sided weight function
characterized by a vector \code{steps} and vector \code{alpha}
parameters. The \code{alpha} parameter determines an alpha
parameter of Dirichlet distribution which cumulative sum
is used for the weights omega.}
\item{\code{"one.sided"}}{for a one-sided weight function
characterized by either a vector \code{steps} and vector
\code{alpha} parameter, leading to a monotonic one-sided
function, or by a vector \code{steps}, vector \code{alpha1},
and vector \code{alpha2} parameters leading non-monotonic
one-sided weight function. The \code{alpha} / \code{alpha1} and
\code{alpha2} parameters determine an alpha parameter of
Dirichlet distribution which cumulative sum is used for
the weights omega.}
}}

\item{parameters}{list of appropriate parameters for a given
\code{distribution}.}

\item{prior_weights}{prior odds associated with a given distribution.
The model fitting function usually creates models corresponding to
all combinations of prior distributions for each of the model
parameters, and sets the model priors odds to the product of
its prior distributions.}
}
\value{
\code{prior_weightfunction} returns an object of class 'prior'.
}
\description{
\code{prior_weightfunction} creates a prior distribution for fitting
a RoBMA selection model. The prior can be visualized by the \code{plot} function.
}
\examples{
p1 <- prior_weightfunction("one-sided", parameters = list(steps = c(.05, .10), alpha = c(1, 1, 1)))

# the prior distribution can be visualized using the plot function
# (see ?plot.prior for all options)
plot(p1)
}
\seealso{
\code{\link[BayesTools:plot.prior]{plot.prior()}}
}
