% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{lmrobdetDCML}
\alias{lmrobdetDCML}
\title{Robust Distance Constrained Maximum Likelihood estimators for linear regression}
\usage{
lmrobdetDCML(formula, data, subset, weights, na.action, model = TRUE,
  x = !control$compute.rd, y = FALSE, singular.ok = TRUE,
  contrasts = NULL, offset = NULL, control = lmrobdet.control())
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an optional data frame, list or environment containing
the variables in the model. If not found in \code{data}, model variables
are taken from \code{environment(formula)}, which usually is the
root environment of the current R session.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{weights}{an optional vector of weights to be used in the fitting process.}

\item{na.action}{a function to indicates what should happen when the data contain NAs.
The default is set by the \link{na.action} setting of \code{\link[base]{options}}, and is
\code{na.fail} if that is unset.}

\item{model}{logical value indicating whether to return the model frame}

\item{x}{logical value indicating whether to return the model matrix}

\item{y}{logical value indicating whether to return the vector of responses}

\item{singular.ok}{logical value. If \code{FALSE} a singular fit produces an error.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \link{model.matrix.default}.}

\item{offset}{this can be used to specify an a priori known component to be included
in the linear predictor during fitting. An offset term can be included in the formula
instead or as well, and if both are specified their sum is used.}

\item{control}{a list specifying control parameters as returned by the function
\link{lmrobdet.control}.}
}
\value{
A list with the following components:
\item{coefficients}{The estimated vector of regression coefficients}
\item{scale}{The estimated scale of the residuals}
\item{residuals}{The vector of residuals associated with the robust fit}
\item{converged}{Logical value indicating whether IRWLS iterations for the MM-estimator have converged}
\item{iter}{Number of IRWLS iterations for the MM-estimator}
\item{rweightsMM}{Robustness weights for the MM-estimator}
\item{fitted.values}{Fitted values associated with the robust fit}
\item{rank}{Numeric rank of the fitted linear model}
\item{cov}{The estimated covariance matrix of the regression estimates}
\item{df.residual}{The residual degrees of freedom}
\item{contrasts}{(only where relevant) the contrasts used}
\item{xlevels}{(only where relevant) a record of the levels of the factors used in fitting}
\item{call}{the matched call}
\item{model}{if requested, the model frame used}
\item{x}{if requested, the model matrix used}
\item{y}{if requested, the response vector used}
\item{na.action}{(where relevant) information returned by model.frame on the special handling of NAs}
}
\description{
This function computes robust Distance Constrained Maximum Likelihood
estimators for linear models.
}
\details{
This function computes Distance Constrained Maximum Likelihood regression estimators
computed using an MM-regression estimator based on Pen~a-Yohai
candidates (instead of subsampling ones). 
This function makes use of the functions \code{lmrob.fit},
\code{lmrob..M..fit}, \code{.vcov.avar1}, \code{lmrob.S} and  
\code{lmrob.lar}, from robustbase,
along with utility functions used by these functions, 
modified so as to include use of the analytic form of the
optimal psi and rho functions (for the optimal psi function , see
Section 5.8.1 of Maronna, Martin, Yohai and Salibian Barrera, 2019)
}
\examples{
data(coleman, package='robustbase')
m1 <- lmrobdetDCML(Y ~ ., data=coleman)
m1
summary(m1)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{DCML}}, \code{\link{MMPY}}, \code{\link{SMPY}}
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, based on \code{lmrob}
}
