% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{lmrobLinTest}
\alias{lmrobLinTest}
\alias{rob.linear.test}
\title{Robust likelihood ratio test for linear hypotheses}
\usage{
lmrobLinTest(object1, object2)
}
\arguments{
\item{object1}{an \code{lmrob} object with the fit corresponding to the complete model}

\item{object2}{an \code{lmrob} object with the fit corresponding to the model
restricted under the null linear hypothesis.}
}
\value{
A list with the following components: c("test","chisq.pvalue","f.pvalue","df")
\item{test}{The value of the F-statistic}
\item{f.pvalue}{p-value based on the F distribution}
\item{chisq.pvalue}{p-value based on the chi-squared distribution}
\item{df}{degrees of freedom}
}
\description{
This function computes a robust likelihood ratio test for linear hypotheses.
}
\examples{
data(oats)
cont <- lmrobdet.control(bb = 0.5, efficiency = 0.85, family = "bisquare")
oats1M <- lmrobM(response1 ~ variety+block, control=cont, data=oats)
oats1M_var <- lmrobM(response1 ~ block, control=cont, data=oats)
( anov1M_var <- rob.linear.test(oats1M, oats1M_var) )

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Victor Yohai, \email{vyohai@gmail.com}
}
