#' Waste data
#'
#' Waste data. The original data are the result of a study on production
#' waste and land use by Golueke and McGauhey (1970), and contain nine variables,
#' of which we consider six.
#'
#' Format: 40 cases and 6 continuous variables.
#' Description: The columns are
#' 1. industrial land (acres)
#' 2. fabricated metals (acres)
#' 3. trucking and wholesale trade (acres)
#' 4. retail trade (acres)
#' 5. restaurants and hotels (acres)
#' 6. solid waste (millions of tons), response
#'
#' @docType data
#'
#' @usage data(waste)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @references Golueke, C.G. and McGauhey, P.H. (1970), Comprehensive Studies of
#' Solid Waste Management, US Department of Health, Education and Welfare, Public
#' Health Services Publication No. 2039.
#'
#' @source Golueke, C.G. and McGauhey, P.H. (1970), Comprehensive Studies of
#' Solid Waste Management, US Department of Health, Education and Welfare, Public
#' Health Services Publication No. 2039.
#'
#' @examples
#' data(waste)
"waste"
