% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NearestNeigbour.R
\name{C.FRNN.O.FRST}
\alias{C.FRNN.O.FRST}
\title{The fuzzy-rough ownership nearest neighbor algorithm}
\usage{
C.FRNN.O.FRST(decision.table, newdata, control = list())
}
\arguments{
\item{decision.table}{a \code{"DecisionTable"} class representing the decision table. See \code{\link{SF.asDecisionTable}}.
It should be noted that the data must be numeric values instead of strings/characters.}

\item{newdata}{a \code{"DecisionTable"} class representing data for the test process. 

       See \code{\link{SF.asDecisionTable}}.}

\item{control}{a list of other parameters.
\itemize{
\item \code{m}: the weight of distance. The default value is 2.
}}
}
\value{
A matrix of predicted classes of newdata.
}
\description{
It is used to predict classes of new datasets/patterns based on the fuzzy-rough ownership nearest neighbor algorithm (FRNN.O) 
proposed by (Sarkar, 2007).
}
\details{
This method improves fuzzy \eqn{k}-nearest neighbors (FNN) by introducing rough sets into it. 
To avoid determining \eqn{k} by trial and error procedure, this method uses all training data. Uncertainties in data are accommodated by 
introducing the rough ownership function. It is the following equation \eqn{o_c} of each class expressing a squared weighted distance between a test pattern and all training data \eqn{d}
and constrained fuzzy membership \eqn{\mu_{C_c}}.

\eqn{o_c(y) = \frac{1}{|X|}\mu_{C_c}(x)\exp{(-d^{1/(q-1)})}}

where \eqn{d = \sum_{j=1}^{N}K_j(y_j-x_{ij})^2}

The predicted value of \eqn{y} is obtained by selecting class \eqn{c} where \eqn{o_c(y)} is maximum.
}
\examples{
#############################################################
## In this example, we are using Iris dataset.
## It should be noted that since the values of the decision attribute are strings,
## they should be transformed into numeric values using unclass()
#############################################################
data(iris)
## shuffle the data
set.seed(2)
irisShuffled <- iris[sample(nrow(iris)),]

## transform values of the decision attribute into numerics
irisShuffled[,5] <- unclass(irisShuffled[,5])

## split the data into training and testing data
iris.training <- irisShuffled[1:105,]
iris.testing <- irisShuffled[106:nrow(irisShuffled),1:4]

## convert into the standard decision table
colnames(iris.training) <- c("Sepal.Length", "Sepal.Width", "Petal.Length", 
                             "Petal.Width", "Species")
decision.table <- SF.asDecisionTable(dataset = iris.training, decision.attr = 5, 
                                    indx.nominal = c(5))
tst.iris <- SF.asDecisionTable(dataset = iris.testing)

## in this case, we are using "gradual" for type of membership					   
control <- list(m = 2)

\dontrun{res.test.FRNN.O <- C.FRNN.O.FRST(decision.table = decision.table, newdata = tst.iris, 
                                 control = control)}

}
\references{
M. Sarkar, "Fuzzy-Rough Nearest-Neighbor Algorithm in Classification" 
Fuzzy Sets and Systems, vol. 158, no. 19, p. 2123 - 2152 (2007).
}
\seealso{
\code{\link{C.FRNN.FRST}},  
\code{\link{C.POSNN.FRST}}
}
\author{
Lala Septem Riza
}
