% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOFunctions.R
\name{SF.asFeatureSubset}
\alias{SF.asFeatureSubset}
\title{Converting custom attribute name sets into a FeatureSubset object}
\usage{
SF.asFeatureSubset(colNames, decisionTable = NULL,
  attributeNames = NULL, type.method = "custom subset",
  model = "custom")
}
\arguments{
\item{colNames}{a character vector containing names of attributes from a decision table}

\item{decisionTable}{a decision table which contains attributes from colNames, 
can be \code{NULL} and in that case a non-NULL value of \code{attributeNames}
must be given}

\item{attributeNames}{a character vector of names of decision table's attributes,
can be \code{NULL} and in that case a non-NULL value of \code{decisionTable}
must be given}

\item{type.method}{an indicator of the method used for selecting the attributes}

\item{model}{an indicator of the model used for selecting the attributes}
}
\value{
an object of a class FeatureSubset
}
\description{
The function can be used to change a custom set of attribute names from
a decision table into an object of the FeatureSubset class. It can be useful
for converting results of discernibility matrix-based attribute selection
methods (i.e. functions FS.all.reducts.computation and FS.one.reduct.computation).
}
\examples{
#############################################################
## Example 1:
#############################################################
data(RoughSetData)
wine.data <- RoughSetData$wine.dt
dim(wine.data)

## selection of an arbitrary attribute subset
attrNames = colnames(wine.data)[1:3]
attrNames
class(attrNames)

## convertion into a FeatureSubset object
reduct <- SF.asFeatureSubset(attrNames, wine.data,
                             type.method = "greedy reduct from a discernibility matrix")

class(reduct)
reduct

}
\author{
Andrzej Janusz
}
