% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rrelperm-package.R
\name{kr3p_StoneII_SwSg}
\alias{kr3p_StoneII_SwSg}
\title{Generate a matrix of three-phase relative permeability data for the water-gas-oil system using the modified Stone II model}
\usage{
kr3p_StoneII_SwSg(
  SWCON,
  SWCRIT,
  SOIRW,
  SORW,
  SOIRG,
  SORG,
  SGCON,
  SGCRIT,
  KRWIRO,
  KROCW,
  KRGCL,
  NW,
  NOW,
  NG,
  NOG,
  NP
)
}
\arguments{
\item{SWCON}{connate water saturation, fraction}

\item{SWCRIT}{critical water saturation, fraction}

\item{SOIRW}{irreducible oil saturation, fraction}

\item{SORW}{residual oil saturation, fraction}

\item{SOIRG}{irreducible oil saturation, fraction}

\item{SORG}{residual oil saturation, fraction}

\item{SGCON}{connate gas saturation, fraction}

\item{SGCRIT}{critical gas saturation, fraction}

\item{KRWIRO}{water relative permeability at irreducible oil}

\item{KROCW}{oil relative permeability at connate water}

\item{KRGCL}{gas relative permeability at connate liquid}

\item{NW}{exponent term for calculating krw}

\item{NOW}{exponent term for calculating krow}

\item{NG}{exponent term for calculating krg}

\item{NOG}{exponent term for calculating krog}

\item{NP}{number of saturation points in the two-phase relative permeability tables, the maximum acceptable value is 501. The number of data points in the three-phase relative permeability table is (0.5 * NP * (NP + 1))}
}
\value{
A matrix with water saturation, gas saturation, oil saturation, and oil relative permeability values, respectively.
}
\description{
The 'kr3p_StoneII_SwSg()' creates a table of three-phase oil relative permeability data for water, gas, and oil saturation values between zero and one. This model reads the water, and gas saturation values in the three-phase region as water, and gas saturation inputs into two-phase relative permeability models
}
\examples{
rel_perm_wgo <- kr3p_StoneII_SwSg(0.15, 0.2, 0.15, 0.15, 0.2, 0.2, 0.05, 0.05,
0.4, 1, 0.3, 3, 2, 4, 2.5, 101)

}
\references{
\insertRef{Stone1970}{Rrelperm}

\insertRef{Fayers1984}{Rrelperm}
}
