% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoxExport.R
\name{writeICESBiotic}
\alias{writeICESBiotic}
\title{Write ICES biotic CSV format file}
\usage{
writeICESBiotic(
  BioticData,
  cruiseSurvey = "NONE",
  cruiseOrganisation = 612,
  allowRemoveSpecies = TRUE,
  save = TRUE
)
}
\arguments{
\item{BioticData}{a \code{BioticData} object from an XML file with NMD biotic version 3 format.}

\item{cruiseSurvey}{set to specify the CruiseSurvey column content. Default to NONE.}

\item{cruiseOrganisation}{set to specify the CruiseOrganisation column content. Default to 612 (IMR's NMD).}

\item{allowRemoveSpecies}{ICES submission will not allow the resulting CSV file to be uploaded if the file contains species not listed in
https://acoustic.ices.dk/Services/Schema/XML/SpecWoRMS.xml . Setting this parameter to TRUE will remove the unlisted species records.}

\item{save}{an output file in collated CSV format will be created if this parameter is set to TRUE.}
}
\value{
List of data.table objects in the ICES acoustic CSV format.
}
\description{
Given an \code{BioticData} object, this function will write an ICES biotic CSV file. Note that this function only supports
\code{BioticData} object that is created from reading an NMD biotic version 3 XML file.
}
