% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoxExport.R
\name{ICESBiotic}
\alias{ICESBiotic}
\title{Convert BioticData to ICESBiotic format}
\usage{
ICESBiotic(
  BioticData,
  SurveyName = character(),
  Country = character(),
  Organisation = integer(),
  AllowRemoveSpecies = TRUE
)
}
\arguments{
\item{BioticData}{a \code{BioticData} object from an XML file with NMD biotic version 3 format.}

\item{SurveyName}{A string naming the survey. Must be one of the names listed on \url{https://vocab.ices.dk/?ref=1453} or NONE (the default).}

\item{Country}{The ISO_3166 code of the country running the cruise. See \url{http://vocab.ices.dk/?ref=337}.}

\item{Organisation}{An integer code representing the organization running the cruise. See \url{https://vocab.ices.dk/?ref=1398} for a list of possible codes (e.g., Institute of Marine Research: 612).}

\item{AllowRemoveSpecies}{ICES submission will not allow the resulting CSV file to be uploaded if the file contains species not listed in
https://acoustic.ices.dk/Services/Schema/XML/SpecWoRMS.xml. Setting this parameter to TRUE will remove the unlisted species records.}
}
\value{
An \code{\link{ICESBioticData}} object.
}
\description{
Given an \code{\link{BioticData}} object, this function converts to ICESBiotic format. Note that this function only supports
\code{BioticData} generated from NMDBiotic version > 3 XML files.
}
