% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RxODE.R
\name{rx.initCmpMgr}
\alias{rx.initCmpMgr}
\title{A compilation manager for RxODE models}
\usage{
rx.initCmpMgr(model, modName, wd, extraC = NULL, debug = TRUE,
  mmod = FALSE, calcJac = NULL, calcSens = NULL, collapseModel = FALSE)
}
\arguments{
\item{model}{This is the ODE model specification.  It can be:
\itemize{
 \item a string containing the set of ordinary differential
    equations (ODE) and other expressions defining the changes in
    the dynamic system.
 \item a file name where the ODE system equation is contained
 \item An ODE expression enclosed in \code{\{\}}
  }

(see also the \code{filename} argument). For
    details, see the sections \dQuote{Details} and
    \dQuote{\code{RxODE Syntax}} below.}

\item{modName}{a string to be used as the model name. This string
is used for naming various aspects of the computations,
including generating C symbol names, dynamic libraries,
etc. Therefore, it is necessary that \code{modName} consists of
simple ASCII alphanumeric characters starting with a letter.}

\item{wd}{character string with a working directory where to
create a subdirectory according to \code{modName}. When
specified, a subdirectoy named after the
\dQuote{\code{modName.d}} will be created and populated with a
C file, a dynamic loading library, plus various other working
files. If missing, the files are created (and removed) in the
temporary directory, and the RxODE DLL for the model is
created in the current directory named \code{rx_????_platform}, for
example \code{rx_129f8f97fb94a87ca49ca8dafe691e1e_i386.dll}}

\item{extraC}{Extra c code to include in the model.  This can be
useful to specify functions in the model.  These C functions
should usually take \code{double} precision arguments, and
return \code{double} precision values.}

\item{debug}{is a boolean indicating if the executable should be
compiled with verbose debugging information turned on.}

\item{mmod}{A boolean telling if the modName from \code{RxODE} was
missing.  This affects how the model is created and used.}

\item{calcJac}{boolean indicating if RxODE will calculate the
Jacobain according to the specified ODEs.}

\item{calcSens}{boolean indicating if RxODE will calculate the
sennsitivities according to the specified ODEs.}

\item{collapseModel}{boolean indicating if RxODE will remove all
LHS variables when calculating sensitivites.}
}
\value{
An object (closure) with the following member functions:
\item{parse}{
    this function parses (translates) the ODE-based model
    specification and generates a C file to implement the model.}
\item{compile}{
    compiles the generated C file for the ODE system
    and dynamically loads the machine code in the shared object.}
\item{dynLoad}{
    if needed, dynamically loads the dynamic library
    produced in the \code{compile()} step.  Note that the shared
    object persists across R sessions, thus the \code{dynLoad} needs
    to be issued as needed.}
\item{dynUnload}{
    this function unloads the previously dynamically loaded
    model object code.  Mainly for internal use.}
\item{ode_solver}{
    a string with the name of the C symbol for this model solver.}
\item{dllfile}{
    a string with the name of the dynamic link (or shared object) file.}
\item{get.modelVars}{
    function that returns a list with 3 character
    vectors, \code{params}, \code{state}, and \code{lhs} of variable
    names (identifiers) used in the model specification.
    These will be output when the model is computed (i.e., the ODE solved).}
\item{isValid}{
    a function that (naively) checks for model validity,
    namely that the C object code reflects the latest model
    specification.}
\item{get.index}{
    helper function to extract the index of one or
    more system variables (state, parameter, or other).}
\item{getObj}{
    internal (not user callable) function.}
}
\description{
This function parses, compiles, links, and loads the shared object
that implements an RxODE model.
}
\details{
The function parses and compiles (if needed) the \code{RxODE}
model specified in the string \code{model} into a dynamic link
library (DLL on Windows) or a shared object (\code{*.so} on
Unix-like systems).

It then dynamically loads this code into the current R
session. (Models previously parsed and compiled in previous R
sessions only need to be dynamically loaded into the current R session.)
}
\examples{
\dontrun{
  cmpMgt <- rx.initCmpMgr(model, "tst1", wd = ".")
}
}
\seealso{
\code{\link{RxODE}}
}
\author{
Matthew L.Fidler
}
\concept{
ordinary differential equations
}
\keyword{ODE}
\keyword{internal}
\keyword{models}
