% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_EnrichmentHeatmap.R
\name{do_EnrichmentHeatmap}
\alias{do_EnrichmentHeatmap}
\title{Create enrichment scores heatmaps.}
\usage{
do_EnrichmentHeatmap(
  sample,
  input_gene_list,
  group.by = NULL,
  verbose = FALSE,
  flip = FALSE,
  cluster_cols = FALSE,
  cluster_rows = FALSE,
  legend.title = "Enrichment",
  row_names_rot = 0,
  column_names_rot = 45,
  cell_size = 5,
  na.value = "grey75",
  legend.position = "bottom",
  use_viridis = TRUE,
  viridis_color_map = "G",
  viridis_direction = -1,
  heatmap.legend.length = 75,
  heatmap.legend.width = 5,
  heatmap.legend.framecolor = "black",
  symmetrical_scale = FALSE,
  heatmap_gap = 0.5,
  row_names_side = "right",
  row_title_side = "left",
  row_title_rot = 90,
  column_title = if (isFALSE(flip)) {
     "List of Genes"
 } else {
     "Groups"
 },
  row_title = if (isFALSE(flip)) {
     "Groups"
 } else {
     "List of Genes"
 },
  nbin = 24,
  ctrl = 100
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{input_gene_list}{\strong{\code{\link[SCpubr]{named_list}}} | Named list of lists of genes to be used as input.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{cluster_cols, cluster_rows}{\strong{\code{\link[base]{logical}}} | Cluster the columns or rows of the heatmaps.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{column_names_rot, row_names_rot}{\strong{\code{\link[base]{numeric}}} | Degree in which to rotate the column and row labels.}

\item{cell_size}{\strong{\code{\link[base]{numeric}}} | Size of each cell in the heatmap.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{use_viridis}{\strong{\code{\link[base]{logical}}} | Whether to use viridis color scales.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{heatmap.legend.length, heatmap.legend.width}{\strong{\code{\link[base]{numeric}}} | Width and length of the legend in the heatmap.}

\item{heatmap.legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the edges and ticks of the legend in the heatmap.}

\item{symmetrical_scale}{\strong{\code{\link[base]{logical}}} | Whether to make the color scale symmetrical. Works best when use_viridis = FALSE.}

\item{heatmap_gap}{\strong{\code{\link[base]{numeric}}} | Gap in cm between heatmaps.}

\item{row_names_side}{\strong{\code{\link[base]{character}}} | Side to put the row names. Either left or right.}

\item{row_title_side}{\strong{\code{\link[base]{character}}} | Side to put the row titles Either left or right.}

\item{row_title_rot}{\strong{\code{\link[base]{numeric}}} | Degree in which to rotate the row titles.}

\item{column_title}{\strong{\code{\link[base]{character}}} | Title for the columns of the heatmaps. Only works with single heatmaps.}

\item{row_title}{\strong{\code{\link[base]{character}}} | Title for the rows of the heatmaps. Only works with single heatmaps.}

\item{nbin}{\strong{\code{\link[base]{numeric}}} | Number of bins to use in \link[Seurat]{AddModuleScore}.}

\item{ctrl}{\strong{\code{\link[base]{numeric}}} | Number of genes in the control set to use in \link[Seurat]{AddModuleScore}.}
}
\value{
A ComplexHeatmap object.
}
\description{
This function computes the enrichment scores for the cells using \link[Seurat]{AddModuleScore} and then aggregates the scores by the metadata variables provided by the user and displays it as a heatmap, computed by \link[ComplexHeatmap]{Heatmap}.
}
\examples{
\donttest{
  # Define your Seurat object.
  sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

  # Genes have to be unique.
  genes <- list("Naive CD4+ T" = rownames(sample)[1:2],
                "EPC1+ Mono" = rownames(sample)[3:4],
                "Memory CD4+" = rownames(sample)[5],
                "B" = rownames(sample)[6],
                "CD8+ T" = rownames(sample)[7],
                "FCGR3A+ Mono" = rownames(sample)[8:9],
                "NK" = rownames(sample)[10:11],
                "DC" = rownames(sample)[12:13],
                "Platelet" = rownames(sample)[14])

  # Default parameters.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    nbin = 1,
                                    ctrl = 10)
  p

  # Custom aggregated values.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    group.by = "orig.ident",
                                    nbin = 1,
                                    ctrl = 10)
  p

  # Transposing the matrix.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    flip = TRUE,
                                    nbin = 1,
                                    ctrl = 10)
  p

  # Rotating the labels.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    flip = TRUE,
                                    column_names_rot = 0,
                                    nbin = 1,
                                    ctrl = 10)
  p

  # Modifying the tile size.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    flip = TRUE,
                                    column_names_rot = 0,
                                    cluster_cols = FALSE,
                                    cluster_rows = TRUE,
                                    cell_size = 7,
                                    nbin = 1,
                                    ctrl = 10)
  p


  # Symmetrical scale viriis.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    flip = TRUE,
                                    column_names_rot = 0,
                                    cluster_cols = FALSE,
                                    cluster_rows = TRUE,
                                    cell_size = 7,
                                    symmetrical_scale = TRUE,
                                    nbin = 1,
                                    ctrl = 10)
  p


  # Modifying the symmetrical scale non viridis.
  p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                    input_gene_list = genes,
                                    flip = TRUE,
                                    column_names_rot = 0,
                                    cluster_cols = FALSE,
                                    cluster_rows = TRUE,
                                    cell_size = 7,
                                    symmetrical_scale = TRUE,
                                    use_viridis = FALSE,
                                    nbin = 1,
                                    ctrl = 10)
  p
}

}
