

#' @title Datasets of country and region names.
#'
#' @description Datasets of country and region names.
#'
#' @name country_region_names
#' @format \code{country_region_names}: A data frame with 644 rows and 3 variables
#' @docType data
#' @author Yingjie Li \email{yingjieli.edu@gmail.com}
#' @keywords dataset
"country_region_names"

#' @title Datasets of shapefiles.
#'
#' @description Datasets of shapefiles..
#'
#' @name shp
#' @format \code{shp}: A data frame with 241 rows and 6 variables
#' @docType data
#' @author Yingjie Li \email{yingjieli.edu@gmail.com}
#' @keywords dataset
"shp"


#' @title Datasets of SDG statistics.
#'
#' @description Datasets of SDG statistics.
#'
#' @name sdgstat
#' @format \code{sdgstat}: A data frame with 62 rows and 4 variables
#' @docType data
#' @author Yingjie Li \email{yingjieli.edu@gmail.com}
#' @keywords dataset
"sdgstat"




#' @title Datasets of SDG keys.
#'
#' @description Datasets of SDG keys.
#'
#' @name SDG_keys
#' @format \code{SDG_keys}: A data frame with 557 rows and 3 variables
#' @docType data
#' @author Yingjie Li \email{yingjieli.edu@gmail.com}
#' @keywords dataset
"SDG_keys"



#' @title List of Names and ISO Code for Countries
#'
#' @name codelist_panel
#' @format ## `codelist_panel`
#' A data frame with 28941 rows and 55 columns:
#' \describe{
#'   \item{country.name.en}{Country name in English}
#'   \item{iso2c, iso3c}{2 & 3 letter ISO country codes}
#'   \item{year}{Year}
#'   ...
#' }
#' @docType data
#' @source <https://en.wikipedia.org/wiki/List_of_countries_and_territories_by_land_and_maritime_borders>
"codelist_panel"




#' @title List SDG Icons
#'
#' @name sdg_icons
#' @format \code{sdg_icons}: External pointer of class "magick-image"
#' @docType data
#' @source <https://www.un.org/sustainabledevelopment/wp-content/uploads/2019/01/SDG_Guidelines_AUG_2019_Final.pdf>
"sdg_icons"



#' @title The Names, ID, and Descriptions of all the 17 SDGs and 169 Targets
#'
#' @name list_of_un_goals_targets
#' @format ## `list_of_un_goals_targets`
#' A data frame with 169 rows and 3 columns:
#' \describe{
#'   \item{GoalID}{The ID of each SDG}
#'   \item{GoalName}{The name of each SDG}
#'   \item{target_id_un}{The name of each Target}
#'   \item{target_desc_un}{The description for each Target}
#' }
#' @docType data
#' @source <https://unstats.un.org/sdgs/indicators/indicators-list/>
"list_of_un_goals_targets"






