% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDMeval.R
\name{SDMeval}
\alias{SDMeval}
\title{Evaluate species distribution models}
\usage{
SDMeval(model)
}
\arguments{
\item{model}{Model produced with \link{compute.maxent} or \link{compute.brt} functions}
}
\value{
Dataframe with the following information
\itemize{
\item \emph{AUC.value}  Returns the AUC (Area Under the Curve) value of the model
\item \emph{maxSSS}     Maximum Sensitivity plus Sensibility threshold of the model
\item \emph{preferential.area} Pixel proportion for which the predicted value is superior to the MaxSSS threshold
\item \emph{omission.rate}  Proportion of data that fall out of the area predicted as preferential
\item \emph{nb.omission} Corresponding number of data that fall out of the predicted preferential area
\item \emph{SD.value} Mean standard deviation of the predicted grid }
}
\description{
Performs model evaluation. Measure of AUC (Area Under the Curve) value, confusion matrix, maxSSS threshold (Maximum Sensitivity plus Specificity), percentage of predicted preferential area based on the MaxSSS value and model stability (standard deviation of pixel values )
}
\details{
Area Under the Curve is a parameter largely refered in the literature and used to test species distribution models performance (Fielding & Bell, 1997). It evaluates the area under the Receiver Operating Curve (ROC), which draws the relationship between 1-specificity (False Positive Rate) and specificity (True Positive Rate). AUC values bordering 1 present models with high True Positive Rate, 0.5 model with random prediction and 0 to models presenting a strong False Positive Rate.

MaxSSS threshold value maximizes the sum of True Positive Rate and True Negative Rate. See Liu et al. (2013) for more information.

Modelling performance can be evaluated with the measure of omission rate, the proportion of occurrences that falls out the area predicted as preferential by the MaxSSS threshold (False Positive Rate).
Models stability is evaluated with the mean standard deviation value of the pixel values of the grid predicted by the model.
}
\examples{
# Model example
load(system.file('extdata','model.RData',package='SDMPlay'))
modelBRT <- model

# Evaluate modelling performance
#SDMPlay:::SDMeval(modelBRT)
}
\references{
Fielding A, & J Bell (1997) A review of methods for the assessment of prediction errors in conservation presence absence models. \emph{Environmental Conservation}, 24(1): 38-49.

Liu C, M White & G Newell (2013) Selecting thresholds for the prediction of species occurrence with presence only data. \emph{Journal of Biogeography}, 40(4): 778-789.
}
