% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/List.R
\name{fromList.SDTree}
\alias{fromList.SDTree}
\title{SDTree fromList method}
\usage{
\method{fromList}{SDTree}(object, ...)
}
\arguments{
\item{object}{an SDTree object with the tree in list format}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
an SDTree object with the tree in Node format
}
\description{
Converts the tree in an SDTree object from
class \code{list} to class \code{Node} \insertCite{Glur2023Data.tree:Structure}{SDModels}.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
fromList(toList(model))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{toList}}
}
\author{
Markus Ulmer
}
