% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITE.R
\name{ITE}
\alias{ITE}
\title{Inference for difference of linear combinations of the regression vectors in
high dimensional generalized linear regressions}
\usage{
ITE(
  X1,
  y1,
  X2,
  y2,
  loading.mat,
  model = "linear",
  intercept = TRUE,
  intercept.loading = TRUE,
  lambda = NULL,
  mu = NULL,
  init.step = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X1}{Design matrix for the first sample, of dimension \eqn{n_1} x
\eqn{p}}

\item{y1}{Outcome vector for the first sample, of length \eqn{n_1}}

\item{X2}{Design matrix for the second sample, of dimension \eqn{n_2} x
\eqn{p}}

\item{y2}{Outcome vector for the second sample, of length \eqn{n_1}}

\item{loading.mat}{Loading matrix, nrow=\eqn{p}, each column corresponds to
a loading of interest}

\item{model}{The high dimensional regression model, either \code{linear} or
\code{logistic} or \code{logistic alternative} or \code{probit}}

\item{intercept}{Should intercept(s) be fitted for the initial estimators
(default = \code{TRUE})}

\item{intercept.loading}{Should intercept be included for the \code{loading}
(default = \code{TRUE})}

\item{lambda}{lambda The tuning parameter in fitting model (default =
\code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the
projection direction (default = \code{NULL})}

\item{init.step}{The initial step size used to compute \code{mu}; if set to
\code{NULL} it is computed to be the number of steps (\code{maxiter}) to
obtain the smallest \code{mu}}

\item{resol}{The factor by which \code{mu} is increased/decreased to obtain
the smallest \code{mu} such that the dual optimization problem for
constructing the projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu} is
increased/decreased to obtain the smallest \code{mu} such that the dual
optimization problem for constructing the projection direction converges
(default = 6)}

\item{alpha}{Level of significance to construct two-sided confidence interval
(default = 0.05)}

\item{verbose}{Should intermediate message(s) be printed (default =
\code{TRUE})}
}
\value{
\item{est.plugin.vec}{The vector of plugin(biased) estimators for the
 linear combination of regression coefficients, length of
  \code{ncol(loading.mat)}; corresponding to different column in
   \code{loading.mat}}
\item{est.debias.vec}{The vector of bias-corrected
  estimators for the linear combination of regression coefficients, length of
  \code{ncol(loading.mat)}; corresponding to different column in
  \code{loading.mat}}
\item{se.vec}{The vector of standard errors of the
  bias-corrected estimators, length of \code{ncol(loading.mat)}; corresponding
  to different column in \code{loading.mat}}
\item{ci.mat}{The matrix of
  two.sided confidence interval for the linear combination, of dimension
  \code{ncol(loading.mat)} x \eqn{2}; the row corresponding to different column
  in \code{loading.mat}}
\item{prob.debias.vec}{The vector of bias-corrected estimators after probability
  transformation, length of \code{ncol(loading.mat)}; corresponding to different
  column in {loading.mat}. The value would be \code{NULL} for non-logistic model.}
\item{prob.se.vec}{The vector of standard errors of the bias-corrected estimators
  after probability transformation, length of \code{ncol(loading.mat)};
  corresponding to different column in \code{loading.mat}. The value would be
  \code{NULL} for non-logistic model.}
}
\description{
Computes the bias-corrected estimator of the difference of
  linearcombinations of the regression vectors for the high dimensional
  generalized linear regressions and the corresponding standard error.
}
\examples{
X1 = matrix(rnorm(100*10), nrow=100, ncol=10)
y1 = -0.5 + X1[,1] * 0.5 + X1[,2] * 1 + rnorm(100)
X2 = matrix(rnorm(90*10), nrow=90, ncol=10)
y2 = -0.4 + X2[,1] * 0.48 + X2[,2] * 1.1 + rnorm(90)
loading1 = c(1, 1, rep(0,8))
loading2 = c(-0.5, -1, rep(0,8))
loading.mat = cbind(loading1, loading2)
Est = ITE(X1, y1, X2, y2, loading.mat, model="linear")

## compute confidence intervals
ci(Est, alpha=0.05, alternative="two.sided")

## summary statistics
summary(Est)
}
