% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnnStream.R
\name{rnnStream}
\alias{rnnStream}
\title{Setup the Input and Output for a Recurrent Neural Network}
\usage{
rnnStream(z, h = 25, nfore = 200)
}
\arguments{
\item{z}{Input in integer values.}

\item{h}{Number of lags used as input.}

\item{nfore}{Data points in the testing subsample.}
}
\value{
A list containing:
\itemize{
\item Xfit - Predictor in training sample (binary).
\item Yfit - Dependent variable in the training sample (binary).
\item yp - Dependent variable in testing sample.
\item Xp - Predictor in the testing sample (binary).
\item X - Predictor in the training sample.
\item yfit - Dependent variable in the training sample.
\item newX - Predictor in the testing sample.
}
}
\description{
R command to setup the input and output for a Recurrent Neural Network.
It is used in
the Wiley book \emph{Statistical Learning with Big Dependent Data}
by Daniel Peña and Ruey S. Tsay (2021).
}
\examples{
output <- rnnStream(rnorm(100), h=5, nfore=20)
}
