% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silh.clus.R
\name{silh.clus}
\alias{silh.clus}
\title{Find the Number of Clusters by the Standard  Silhouette Statistics}
\usage{
silh.clus(nClus, distanceMatrix, method)
}
\arguments{
\item{nClus}{Maximum number of groups.}

\item{distanceMatrix}{Matrix of distances.}

\item{method}{Hierarchical method "single", "average","complete".}
}
\value{
A list containing:
\itemize{
   \item nClus - Number of groups
   \item  list - Silhouette statistics for each value of nclus.
}
}
\description{
Find the number of clusters by the standard Silhouette statistics. The cluster is
hierarchical.
}
\examples{
data(TaiwanAirBox032017)
output_gcc <- GCCmatrix(TaiwanAirBox032017[1:100,1:10])
output <- silh.clus(nClus=3,distanceMatrix=output_gcc$DM ,method="complete")

}
