% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vote.R
\name{vote_update}
\alias{vote_update}
\alias{vote_update.selection}
\title{Extract and adjust voting from a \code{'selection'} object}
\usage{
vote_update(object, ...)

\method{vote_update}{selection}(object, vote_threshold = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{'selection'}.}

\item{...}{This argument is not used and listed for method consistency}

\item{vote_threshold}{A  voting threshold in percentage. A feature is
considered to be important when it receives votes passing the threshold.}
}
\value{
The function returns a vector indicating the features selected by
 EBIC voting with the specified \code{vote_threhold}.
}
\description{
When \code{'selection'} is used with \code{criterion="ebic"} and \code{vote=TRUE}, 
users can use \code{vote_update} to adjust the voting threshold without a need 
of rerun \code{smle_select}.
}
\examples{
set.seed(1)
Data<-Gen_Data(correlation="MA",family = "gaussian")
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
fit_s<-smle_select(fit,vote=TRUE)
plot(fit_s)
vote_update(fit_s,vote_threshold = 0.3)
}
