% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_HD.R
\name{plot.SNSeg_HD}
\alias{plot.SNSeg_HD}
\title{Plotting the output for high-dimensional time series with dimension greater
than 10}
\usage{
\method{plot}{SNSeg_HD}(x, cpts.col = "red", n_plot = 5, ...)
}
\arguments{
\item{x}{a \code{SNSeg_HD} object}

\item{cpts.col}{a specification for the color of the vertical lines at
the change point estimators, see \link[graphics]{par}}

\item{n_plot}{the number of time series to be plotted. The default value is 5.}

\item{...}{additional graphical arguments, see \link[graphics]{plot}
and \link[graphics]{abline}}
}
\description{
Plotting method for S3 objects of class \code{SNSeg_HD}
}
\details{
The location of each change point estimator is plotted as a vertical line
against the input time series.
}
\examples{
\donttest{
n <- 500
p <- 50
nocp <- 5
cp_sets <- round(seq(0,nocp+1,1)/(nocp+1)*n)
num_entry <- 5
kappa <- sqrt(4/5)
mean_shift <- rep(c(0,kappa),100)[1:(length(cp_sets)-1)]
set.seed(1)
ts <- matrix(rnorm(n*p,0,1),n,p)
no_seg <- length(cp_sets)-1
for(index in 1:no_seg){
  tau1 <- cp_sets[index]+1
  tau2 <- cp_sets[index+1]
  ts[tau1:tau2,1:num_entry] <- ts[tau1:tau2,1:num_entry] +
    mean_shift[index]
}

# grid_size defined
result <- SNSeg_HD(ts, confidence = 0.9, grid_size_scale  = 0.05,
                   grid_size = 40)
# plot the first three time series
plot(result, cpts.col = 'red', n_plot = 3)
}

}
