\name{projectIGraph}
\alias{projectIGraph.somRes}
\alias{projectIGraph}

\title{
Compute the projection of a graph on a grid
}

\description{Compute the projection of a graph, provided as an 
\code{\link[igraph]{igraph}} object, on the grid of the \code{somRes} object.}

\usage{
\method{projectIGraph}{somRes}(object, init.graph, \ldots)
}


\arguments{
  \item{object}{a \code{somRes} object.}
  \item{init.graph}{an \link[igraph]{igraph} whose number of vertices is equal
  to the clustering length of the \code{somRes} object.}
  \item{\ldots}{Not used.}
}

\value{
The result is an \code{\link[igraph]{igraph}} which vertexes are the clusters
(the clustering is thus understood as a vertex clustering) and the edges are the
counts of edges in the original graph between two vertices corresponding to the
two clusters in the projected graph or, if \code{init.graph} is a weighted 
graph, the sum of the weights between the pairs of vertices corresponding to the
two clusters.

The resulting igraph object's attributes are: \itemize{
\item the graph attribute \code{layout} which provides the layout of the 
projected graph according to the grid of the SOM;
\item the vertex attributes \code{name} and \code{size} which, respectively 
are the vertex number on the grid and the number of vertexes included in the
corresponding cluster;
\item the edge attribute \code{weight} which gives the number of edges (or the
sum of the weights) between the vertexes of the two corresponding clusters.}
}

\author{Madalina Olteanu \email{madalina.olteanu@univ-paris1.fr}\cr
Nathalie Villa-Vialaneix \email{nathalie.villa-vialaneix@inra.fr}
}

\references{
Olteanu M., Villa-Vialaneix N. (2015) Using SOMbrero for clustering and 
visualizing graphs. \emph{Journal de la Societe Francaise de Statistique},
\strong{156}, 95-119.
}

\seealso{\code{\link{projectIGraph.somSC}} which uses the results of a 
super-clustering to obtain another projected graph. \code{\link{plot.somRes}} 
with the option \code{type="graph"} or \code{\link{plot.somSC}} with the option 
\code{type="projgraph"}.}

\examples{
data(lesmis)
set.seed(7383)
mis.som <- trainSOM(x.data=dissim.lesmis, type="relational", nb.save=10)
proj.lesmis <- projectIGraph(mis.som, lesmis)
\dontrun{plot(proj.lesmis)}
}

\keyword{methods}
