% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot.R
\name{spotControl}
\alias{spotControl}
\title{Default Control list for spot}
\usage{
spotControl(dimension)
}
\arguments{
\item{dimension}{problem dimension, that is, the number of optimized parameters.}
}
\value{
a list
}
\description{
This function returns the default controls for the functions \code{\link{spot}} and \code{\link{spotLoop}}.
Control is a list of the settings: 
\describe{
  \item{\code{funEvals}}{ This is the budget of function evaluations (spot uses no more than funEvals evaluations of fun), defaults to 20.}
  \item{\code{types}}{ Vector of data type of each variable as a string, defaults \code{"numeric"} for all variables.}
  \item{\code{subsetSelect}}{A function that selects a subset from a given set of design points. Default is \code{\link{selectAll}}.}
  \item{\code{subsetControl}}{A list of controls passed to the \code{control} list of the \code{subsetSelect} function. See help 
			of the respective function for details. Default is an empty \code{list}.}
  \item{\code{design}}{A function that creates an initial design of experiment. Functions that accept the same parameters, 
			and return a matrix like \code{\link{designLHD}} or \code{\link{designUniformRandom}} can be used. Default is \code{\link{designLHD}}.}
  \item{\code{designControl}}{A list of controls passed to the \code{control} list of the \code{design} function. See help 
			of the respective function for details. Default is an empty \code{list}.}
  \item{\code{model}}{A function that builds a statistical model of the observed data. Functions that accept the same 
			parameters, and return a matrix like \code{\link{buildKriging}} or \code{\link{buildRandomForest}} 
			can be used. Default is \code{\link{buildKriging}}.}
  \item{\code{modelControl}}{A list of controls passed to the \code{control} list of the \code{model} function. 
			See help of the respective function for details.Default is an empty \code{list}.}
  \item{\code{optimizer}}{A function that is used to optimize based on \code{model}, finding the most promising 
			candidate solutions. Functions that accept the same parameters, and return a matrix like \code{\link{optimLHD}} 
			or \code{\link{optimDE}} can be used. Default is \code{\link{optimLHD}}.}
  \item{\code{optimizerControl}}{A list of controls passed to the \code{control} list of the \code{optimizer} function. 
			See help of the respective function for details. Default is an empty \code{list}.}
  \item{\code{noise}}{Boolean, whether the objective function has noise or not. Default is non-noisy, that is, \code{FALSE}.}
  \item{\code{OCBA}}{Boolean, indicating whether Optimal Computing Budget Allocation (OCBA) should be used in case of a noisy 
			objective function or not. OCBA controls the number of replications for each candidate solution. 
				Note, that \code{replicates} should be larger than one in that case, and that the initial experimental design 
			(see \code{design}) should also have replicates larger one. Default is \code{FALSE}.}
  \item{\code{OCBAbudget}}{The number of objective function evaluations that OCBA can distribute in each iteration. Default is 3.}
  \item{\code{replicates}}{The number of times a candidate solution is initially evaluated, that is, in the initial design, 
			or when created by the optimizer. Default is \code{1}.}
  \item{\code{seedFun}}{An initial seed for the objective function in case of noise, by default \code{NA}. The default means that no seed is set.
			The user should be very careful with this setting. It is intended to generate reproducible experiments for each objective
			function evaluation, e.g., when tuning non-deterministic algorithms. If the objective function uses a constant number
			of random number generations, this may be undesirable. Note, that this seed is by default set prior to each evaluation. A replicated
			evaluation will receive an incremented value of the seed.
			Sometimes, the user may want to call external code using random numbers. To allow for that case, the user can specify an objective function (\code{fun}),
				which has a second parameter \code{seed}, in addition to first parameter (matrix \code{x}). This seed can then be passed
			to the external code, for random number generator initialization. See end of examples section for a demonstration.}
  \item{\code{seedSPOT}}{This value is used to initialize the random number generator. It ensures that experiments are reproducible. Default is \code{1}.}
  \item{\code{duplicate}}{In case of a deterministic (non-noisy) objective function, this handles duplicated candidate solutions.
			By default (\code{duplicate = "EXPLORE"}), duplicates are replaced by new candidate solutions, generated by random 
			sampling with uniform distribution. If desired, the user can set this to "STOP", which means that the optimization
			stops and results are returned to the user (with a warning). This may be desirable, as duplicates can be a indicator
			for convergence, or for a problem with the configuration.
			In case of noise, duplicates are allowed.}
  \item{\code{plots}}{Whether progress should be tracked by a line plot, default is \code{FALSE}}
  \item{\code{progress}}{Whether progress should be visualized, default is \code{FALSE}}
  \item{\code{infillCriterion}}{A function defining an infillCriterion to be used while optimizing a model. Default: NULL. For example check infillExpectedImprovement}
  \item{\code{verbosity}}{Integer level specifying how much output should be given by SPOT. 0 (default) ignores warnings of internal optimizers /models.
             1 will show warnings and output.}
}
}
\keyword{internal}
\keyword{spotDefaultControls()}
