% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funMarkovChain.R
\name{evalMarkovChain}
\alias{evalMarkovChain}
\title{evalMarkovChain}
\usage{
evalMarkovChain(x, conf)
}
\arguments{
\item{x}{vector of parameter values, i.e., parameters of the MarkovChain model to evaluate with the function.
\describe{
    \item{\code{p}}{num  [0;1] proportion of confirmed cases}
    \item{\code{beta}}{num Transmission rate from susceptible to infected. See \code{\link[SimInf]{SIR}}. }
    \item{\code{gamma}}{num Recovery rate from infected to recovered. See \code{\link[SimInf]{SIR}}. }
    \item{\code{CFR}}{num Case Fatalities Rate}
}}

\item{conf}{a list with entries
\describe{
    \item{\code{regionData}}{ A data frame with observations of 3 variables:
     \describe{
             \item{\code{date}}{Date, format: "2020-01-22" "2020-01-23" "2020-01-24" "2020-01-25" ...}
             \item{\code{confirmed}}{num  0 0 0 0 0 0 0 0 0 0 ..}
             \item{\code{fatalities}}{fatalities: num  0 0 0 0 0 0 0 0 0 0 ...}
              }
     }
      \item{\code{N}}{N population size}
 }}
}
\value{
value (log RMSE)
}
\description{
Evaluation function for the optimization of continuous time Markov chains models using
\code{\link[SimInf]{SIR}} models.
}
\details{
Performs a SIR model simulation for one specific parameter setting using
the \code{\link{modelMarkovChain}} function and evaluates the result
from the simulation model output with the real data. The RMSE is
used as the performance metric.
}
\examples{
require("SimInf")
data <- preprocessInputData(regionTrain, regionPopulation)
set.seed(123)
data <- data[[1]]
N <- attr(data, "regionPopulation")
# params:  x = (p, beta, gamma, CFR)
x <- c(0.01, 0.01, 0.1, 0.01)
# Simulate only 2 days
conf <- list(regionData = data[1:2, ], N = N)
evalMarkovChain(x = x, conf=conf)

}
