% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_occ.R
\name{load_occ}
\alias{load_occ}
\title{Load occurrence data}
\usage{
load_occ(path = getwd(), Env, file = NULL, ..., Xcol = "Longitude",
  Ycol = "Latitude", Spcol = NULL, GeoRes = TRUE,
  reso = max(res(Env@layers[[1]])), verbose = TRUE, GUI = FALSE)
}
\arguments{
\item{path}{character. Path to the directory that contains the occurrence table.}

\item{Env}{raster stack. Environmental variables in the form of a raster stack used to
perform spatial thinning (can be the result of the
\code{\link{load_var}} function).}

\item{file}{character. File containing the occurrence table, if NULL
(default) the .csv file located in the path will be loaded.}

\item{...}{additional parameters given to \code{\link[utils]{read.csv}}.}

\item{Xcol}{character. Name of the Latitude or X coordinate variable.}

\item{Ycol}{character. Name of the Longitude or Y coordinate variable.}

\item{Spcol}{character. Name of the column containing species names or IDs.}

\item{GeoRes}{logical. If \code{TRUE}, performs geographical thinning on occurrences
to limit geographical biases in the SDMs.}

\item{reso}{numeric. Resolution used to perform the geographical thinning,
default is the resolution of \code{Env}.}

\item{verbose}{logical. If \code{TRUE}, allows the function to print text in the
console.}

\item{GUI}{logical. Parameter reserved for graphical interface.}
}
\value{
A data frame containing the occurrence dataset (spatially thinned or
 not).
}
\description{
Load occurrence data from CSV file to perform \code{\link{modelling}},
\code{\link{ensemble_modelling}} or \code{\link{stack_modelling}}.
}
\examples{

\dontrun{
load_occ(path = system.file('extdata',  package = 'SSDM'), Env,
         Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
         file = 'Occurrences.csv', sep = ',')
}

}
\seealso{
\code{\link{load_var}} to load environmental variables.
}
