% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslLapRLS}
\alias{sslLapRLS}
\title{Laplacian Regularized Least Squares}
\usage{
sslLapRLS(xl, yl, xu, graph.type = "exp", dist.type = "Euclidean", alpha,
  alpha1, alpha2, k, epsilon, kernel = "gaussian", c1, c2, c3, deg, gamma,
  alpha3, alpha4, gammaA = 1, gammaI = 1)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data.}

\item{yl}{a n * 1 binary labels(1 or -1).}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{graph.type}{character string; which type of graph should be created? Options
include \code{knn},\code{enn},\code{tanh} and \code{exp}.
\itemize{\item \code{knn} :kNN graphs.Nodes i, j are connected by an edge if i is in j 's k-nearest-neighborhood. \code{k} is a hyperparameter that controls the density of the graph.
\item \code{enn} :epsilon-NN graphs. Nodes i, j are connected by an edge, if the distance \code{d(i, j ) < epsilon}. The  hyperparameter \code{epsilon} controls neighborhood radius.
\item \code{tanh}:tanh-weighted graphs.  \code{w(i,j) = (tanh(alpha1(d(i,j) - alpha2)) + 1)/2}.where \code{d(i,j)} denotes the distance between point i and j. Hyperparameters \code{alpha1} and \code{alpha2} control the slope and cutoff value respectively.
\item \code{exp} :exp-weighted graphs.\code{w(i,j) = exp(-d(i,j)^2/alpha^2)},where \code{d(i,j)} denotes the distance between point i and j. Hyperparameter \code{alpha} controls the decay rate.}}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{alpha}{numeric parameter needed when \code{graph.type = exp}}

\item{alpha1}{numeric parameter needed when \code{graph.type = tanh}}

\item{alpha2}{numeric parameter needed when \code{graph.type = tanh}}

\item{k}{integer parameter needed when \code{graph.type = knn }}

\item{epsilon}{numeric parameter needed when \code{graph.type = enn}}

\item{kernel}{character string; it controls four types of common kernel functions:\code{linear},\code{polynomial},\code{gaussian} and \code{sigmoid}.
\itemize{\item \code{linear}:Linear kernel;\code{k(x,y)=dot(x,y)+c1},where \code{dot(x,y)} is the dot product of vector x and y,\code{c1} is a constant term.
\item \code{polynomial}:Polynomial kernel;\code{k(x,y)=(alpha3 *dot(x,y)+c2)^deg},where \code{dot(x,y)} is the dot product of vector x and y.Adjustable parameters are the slope \code{alpha3}, the constant term \code{c2} and the polynomial degree \code{deg}.
\item \code{gaussian}:Gaussian kernel;\code{k(x,y)=exp(-gamma*d(x,y)^2)},where \code{d(x,y)} is Euclidean distace between vector x and y,\code{gamma} is a slope parameter.
\item \code{sigmoid}:Hyperbolic Tangent (Sigmoid) Kernel;\code{k(x,y)=tanh(alpha4*dot(x,y)+c3)},where \code{d(x,y)} is dot product of vector x and y.There are two adjustable parameters in the sigmoid kernel, the slope \code{alpha4} and the intercept constant \code{c3}.}}

\item{c1}{numeric parameter needed when \code{kernel = linear}}

\item{c2}{numeric parameter needed when \code{kernel = polynomial}}

\item{c3}{numeric parameter needed when \code{kernel = sigmoid}}

\item{deg}{integer parameter needed when \code{kernel = polynomial}}

\item{gamma}{numeric parameter needed when \code{kernel = gaussian}}

\item{alpha3}{numeric parameter needed when \code{kernel = polynomial}}

\item{alpha4}{numeric parameter needed when \code{kernel = sigmoid}}

\item{gammaA}{numeric; model parameter.}

\item{gammaI}{numeric; model parameter.}
}
\value{
a m * 1 integer vector representing the predicted labels  of  unlabeled data(1 or -1).
}
\description{
Laplacian Regularized Least Squares
}
\examples{
data(iris)
xl<-iris[c(1:20,51:70),-5]
xu<-iris[c(21:50,71:100),-5]
yl<-rep(c(1,-1),each=20)
# combinations of different graph types and kernel types
# graph.type =knn, kernel =linear
yu1<-sslLapRLS(xl,yl,xu,graph.type="knn",k=10,kernel="linear",c1=1)
# graph.type =knn, kernel =polynomial
yu2<-sslLapRLS(xl,yl,xu,graph.type="knn",k=10,kernel="polynomial",c2=1,deg=2,alpha3=1)
# graph.type =knn, kernel =gaussian
yu3<-sslLapRLS(xl,yl,xu,graph.type="knn",k=10,kernel="gaussian",gamma=1)
# graph.type =knn, kernel =sigmoid
yu4<-sslLapRLS(xl,yl,xu,graph.type="knn",k=10,kernel="sigmoid",c3=-10,
alpha4=0.001,gammaI  = 0.05,gammaA = 0.05)
# graph.type =enn, kernel =linear
yu5<-sslLapRLS(xl,yl,xu,graph.type="enn",epsilon=1,kernel="linear",c1=1)
# graph.type =enn, kernel =polynomial
yu6<-sslLapRLS(xl,yl,xu,graph.type="enn",epsilon=1,kernel="polynomial",c2=1,deg=2,alpha3=1)
# graph.type =enn, kernel =gaussian
yu7<-sslLapRLS(xl,yl,xu,graph.type="enn",epsilon=1,kernel="gaussian",gamma=1)
# graph.type =enn, kernel =sigmoid
yu8<-sslLapRLS(xl,yl,xu,graph.type="enn",epsilon=1,kernel="sigmoid",c3=-10,
alpha4=0.001,gammaI  = 0.05,gammaA = 0.05)
# graph.type =tanh, kernel =linear
yu9<-sslLapRLS(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1,kernel="linear",c1=1)
# graph.type =tanh, kernel =polynomial
yu10<-sslLapRLS(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1,
kernel="polynomial",c2=1,deg=2,alpha3=1)
# graph.type =tanh, kernel =gaussian
yu11<-sslLapRLS(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1,kernel="gaussian",gamma=1)
# graph.type =tanh, kernel =sigmoid
yu12<-sslLapRLS(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1,
kernel="sigmoid",c3=-10,alpha4=0.001,gammaI  = 0.05,gammaA = 0.05)
# graph.type =exp, kernel =linear
yu13<-sslLapRLS(xl,yl,xu,graph.type="exp",alpha=1,kernel="linear",c1=1)
# graph.type =exp, kernel =polynomial
yu14<-sslLapRLS(xl,yl,xu,graph.type="exp",alpha=1,kernel="polynomial",c2=1,deg=2,alpha3=1)
# graph.type =exp, kernel =gaussian
yu15<-sslLapRLS(xl,yl,xu,graph.type="exp",alpha=1,kernel="gaussian",gamma=1)
# graph.type =exp, kernel =sigmoid
yu16<-sslLapRLS(xl,yl,xu,graph.type="exp",alpha=1,kernel="sigmoid",
c3=-10,alpha4=0.001,gammaI  = 0.05,gammaA = 0.05)
}
\author{
Junxiang Wang
}
\references{
Olivier Chapelle, Bernhard Scholkopf and Alexander Zien (2006). Semi-Supervised Learning.The MIT Press.
}
\seealso{
\code{\link{pr_DB}} \code{\link{dist}}
}

