\name{SUE.lm}
\alias{SUE.lm}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The Subsampling Method for Linear Regression 
}
\description{
This function computes the subsampling method estimators for linear regression. 
}
\usage{
SUE.lm(formula, data = list(), k, ns, r, constant = 0.25, consistency.check = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{
it is an object that indicates the variables used in the regression. a formula object has the form y = x1 +x2 +...+xp, where y is the name of the dependent variable, and x1, ..., xp are the names of the explanatory variables.
}
  \item{data}{
This argument is used only if the variables belong to a data frame, in which case data is the name of the data frame.
}
  \item{k}{
It is the total number of subsamples to be generated.
}
  \item{ns}{
It is the subsample size.
}
  \item{r}{
It is the number of subsamples to be combined. The function \code{\link{parameters}} is especially designed to compute these three parameters of subsampling method.
}  
  \item{constant}{
is a predetermined parameter which is used to control the distance between two estimated values. It only works under the condition that consistency,check = "TURE". The default value is 0.25. However. users can try different values to get better result. What has to be mentioned is that: if the value is set too small, the function will fail the consistency check easily which result in running the program for many more times, but if the value is too large, the result may be not reliable. It is user's job to balance these situations.
}
  \item{consistency.check}{
The argument decides if we conduct consistency check. The defualt value is TURE. We highly recommend to always check the consistency of the result after computing. It can sufficiently increase the reliability of subsampling method.
}
}
\value{
Apart from the same output components as the object of class "lm", such as \code{coefficients}, \code{residuals} and \code{fitted.values}, the main components of the output are:
  \item{combined.sample }{is the final combined sample generated by the subsampling method, It is supposed to be the fine data without outliers.}
  \item{sample.size }{is the sample size of the combined sample, which is convenient for user to compute the number of outliers.}
  \item{mse }{They are MSEs of the regressions of r chosen subsamples.}
  \item{beta }{They are coefficient parameters of the regressions of r chosen subsamples.}
  \item{check }{It is a logistic output which indicates whether the subsampling method fails the consistency check or not.}
}
\author{
Jim Yi
}
\examples{
##We analysis the well known stackloss data by using ordinary linear method and the subsampling method. 
##We also try two m values, m = 2 and 4, which represent toughly 10\% and 20\% working 
##proportion of outliers in the data. The subsample size is chosen to be the default size of ns = 11.

data(stackloss)
a1=lm(stack.loss~Air.Flow+Water.Temp+Acid.Conc.,data=stackloss)
a2=SUE.lm(stack.loss~Air.Flow+Water.Temp+Acid.Conc.,data=stackloss,k=57,ns=11,r=6, 
	consistency.check=TRUE,constant=0.25)
a3=SUE.lm(stack.loss~Air.Flow+Water.Temp+Acid.Conc.,data=stackloss,k=327,ns=11,r=5, 
	consistency.check=TRUE,constant=0.25)
par(mfrow=c(2,2))
plot(a1$fitted.values,a1$residuals,xlab="(a) fitted values",ylab="residuals",ylim=c(-12,12))
abline(h=0)
abline(h=9.7,lty=2)
abline(h=-9.7,lty=2)
plot(SUE.fitted.values(a2),SUE.residuals(a2),xlab="(b) fitted values",ylab="residuals",ylim=c(-12,12))
abline(h=0)
abline(h=9,lty=2)
abline(h=-9,lty=2)
plot(SUE.fitted.values(a3),SUE.residuals(a3),xlab="(c) fitted values",ylab="residuals",ylim=c(-12,12))
abline(h=0)
abline(h=3.75,lty=2)
abline(h=-3.75,lty=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }