% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmixCraftHD.R
\name{OmixCraftHD}
\alias{OmixCraftHD}
\title{Simulation of high-dimensional data with predefined single factor or multiple factors in multi-omics}
\usage{
OmixCraftHD(
  vector_features = c(2000, 2000),
  n_samples = 50,
  sigmas_vector = c(3, 5),
  n_factors = 3,
  num.factor = "multiple",
  advanced_dist = NULL
)
}
\arguments{
\item{vector_features}{Vector of features assigned to the two simulated datasets respectively '1' first dataset, '2' second dataset}

\item{n_samples}{The number of samples common between the two simulated datasets}

\item{sigmas_vector}{Vector for the noise variability for the two simulated datasets respectively,  '1' first dataset, '2' second dataset}

\item{n_factors}{Number of predefined factors}

\item{num.factor}{Category of factors to be simulated specified as 'single', or 'multiple'.}

\item{advanced_dist}{Applicable only when num.factor = 'multiple'. Contains six possible arguments, '', NULL, 'mixed', 'omic.one', or 'omic.two', 'exclusive'}
}
\value{
A list containing:
\itemize{
\item \code{dataset_1}: A matrix or data frame representing the first simulated dataset with rows as samples and columns as features.
\item \code{dataset_2}: A matrix or data frame representing the second simulated dataset with rows as samples and columns as features.
\item \code{factors}: A matrix representing the predefined factors used in generating the datasets. If \code{num.factor} is 'single', this contains one set of factors. If \code{num.factor} is 'multiple', it contains multiple sets of factors.
\item \code{noise}: A list containing the noise terms added to both datasets based on the \code{sigmas_vector}.
\item \code{factor_assignment}: A vector indicating how factors are assigned to datasets, depending on the \code{num.factor} and \code{advanced_dist} settings.
}
The output provides simulated multi-omics datasets with predefined latent factors and noise, which can be used to model complex biological data structures.

A list containing:
\itemize{
\item \code{dataset_1}: A matrix or data frame representing the first simulated dataset with rows as samples and columns as features.
\item \code{dataset_2}: A matrix or data frame representing the second simulated dataset with rows as samples and columns as features.
\item \code{factors}: A matrix representing the predefined factors used in generating the datasets. If \code{num.factor} is 'single', this contains one set of factors. If \code{num.factor} is 'multiple', it contains multiple sets of factors.
\item \code{noise}: A list containing the noise terms added to both datasets based on the \code{sigmas_vector}.
\item \code{factor_assignment}: A vector indicating how factors are assigned to datasets, depending on the \code{num.factor} and \code{advanced_dist} settings.
}
The output provides simulated multi-omics datasets with predefined latent factors and noise, which can be used to model complex biological data structures.
}
\description{
Simulation of high-dimensional data with predefined single factor or multiple factors in multi-omics
}
\examples{
# Examples
set.seed(1234)
output_obj <- OmixCraftHD(
  vector_features = c(2000,3000),
  sigmas_vector=c(8,5),
  n_samples=100,
  n_factors=5,
  num.factor='multiple',
  advanced_dist='mixed'
)
output_obj <- OmixCraftHD(
  vector_features = c(5000,3000),
  sigmas_vector=c(3,4),
  n_samples=30, n_factors=1
)

}
