% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_reserve.R
\name{map_reserve}
\alias{map_reserve}
\title{Map a reserve}
\usage{
map_reserve(nerr_site_id, text_sz = 6, text_col = "black", f = 0.2)
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to map, first three characters used by NERRS or vector of stations to map using the first five characters}

\item{text_sz}{numeric value for text size of station names, passed to \code{\link[ggplot2]{geom_text}}}

\item{text_col}{chr string for text color of station names, passed to \code{\link[ggplot2]{geom_text}}}

\item{f}{numeric passed to \code{\link[ggmap]{make_bbox}} as expansion around the bounding box for stations at a NERR site, increase to expand map zoom chr}
}
\value{
A \code{\link[ggplot2]{ggplot}} object for plotting.
}
\description{
Create a map of all the stations in a reserve
}
\details{
This function is a simple wrapper to functions in the ggmap package which returns a map of all of the stations at a NERRS reserve.  The \code{f} argument may have to be chosen through trial and error depending on the spatial extent of the reserve.  A local data file included with the package is used to get the latitude and longitude values of each station.  The files includes only active stations as of January 2015.
}
\examples{
\dontrun{
map_reserve('jac')
}
}
\seealso{
\code{\link[ggmap]{get_map}}, \code{\link[ggmap]{ggmap}}, \code{\link[ggplot2]{ggplot}}
}
\concept{analyze}
