% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fillNA}
\alias{fillNA}
\title{Filling in missing values

\code{fillNA} uses values of a variable from one data set to fill in missing values in another.}
\usage{
fillNA(x, y, xvar, yvar = NULL, KeyVar)
}
\arguments{
\item{x}{the data frame with the variable you would like to fill in.}

\item{y}{the data frame with the variable you would like to use to fill in \code{D1}.}

\item{xvar}{a character string of the name of the variable in \code{D1} you want to fill in.}

\item{yvar}{an optional character string of variable name in \code{D2} that you would like to use to fill in.}

\item{KeyVar}{a character vector of variable names that are shared by \code{D1} and \code{D2} that can be used to join the data frames.}
}
\description{
Filling in missing values

\code{fillNA} uses values of a variable from one data set to fill in missing values in another.
}
\examples{
# Create data set with missing values
naDF <- data.frame(a = sample(c(1,2), 100, rep=TRUE),
                   b = sample(c(3,4), 100, rep=TRUE),
                   fNA = sample(c(100, 200, 300, 400, NA), 100, rep=TRUE))

# Created full data set
fillDF <- data.frame(a = c(1,2,1,2),
                     b = c(3,3,4,4),
                     fFull = c(100, 200, 300, 400))

# Fill in missing f's from naDF with values from fillDF
Filled <- fillNA(naDF, fillDF, xvar = "fNA", yvar = "fFull", KeyVar = c("a", "b"))
}

