% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{restrict_to_country}
\alias{restrict_to_country}
\title{restricts data to a specified country}
\usage{
restrict_to_country(dt, ct, rectangle = FALSE, tol = 1)
}
\arguments{
\item{dt}{the data table.}

\item{ct}{name of the country, or vector containing multiple country names}

\item{rectangle}{logical. If FALSE (default), the data is restricted to the gridcells for which the centerpoint lies within the selected country (e.g. for computing mean scores for a country).
If TRUE, the data is kept for a rectangle containing the entire country, therefore also containing gridpoints outside the country. This is the preferred option for plotting data
for a specific country.}

\item{tol}{Only used when \code{rectangle == TRUE}. A tolerance value for widening the plotting window, making things look a bit nicer.}
}
\value{
the data table, restricted to the selected country
}
\description{
Restricts a dataset to one or more countries, specified by their names. If you have lon/lat data and don't know
which countries these coordinates belong to, see \code{\link{add_country_names}}. Can restrict data to a rectangle around a given country
as well (usually looks nicer for plotting).
}
\examples{
# example data:
ex_dt = chirps_monthly[lat < 0 & month == 11 & year == 2020]
dt = restrict_to_country(ex_dt,'Kenya')

}
