% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_tercile_cat}
\alias{add_tercile_cat}
\title{Add a tercile-category column to a data table}
\usage{
add_tercile_cat(
  dt,
  datacol = NULL,
  years = NULL,
  by = setdiff(dimvars(dt), c("year", "member"))
)
}
\arguments{
\item{dt}{the data table.}

\item{datacol}{Name of the column where the data is stored. If NULL, the function guesses.}

\item{years}{Optional, if provided only these years are used for establishing climatology terciles.}

\item{by}{names of columns to group by.}
}
\value{
The provided data table with an extra column tercile_cat
}
\description{
Given a data table with multiple years of data, this function derives the tercile category per year.
It first derives terciles for the data and then returns, for each row, a -1 if the data falls into
the lowest tercile, 0 if it falls between 1st and second tercile, and +1 if it falls above the third tercile.
Allows grouping by levels (e.g. months and location-coordinates): Tercile categories are derived separately
for each level.
}
\examples{
\donttest{
dt = add_tercile_cat(chirps_monthly)
}
}
