% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\name{download_chirps_prelim_aux}
\alias{download_chirps_prelim_aux}
\title{Auxiliary function for downloading the preliminary CHIRPS monthly data}
\usage{
download_chirps_prelim_aux(
  years,
  months,
  extent,
  timeout_limit = 300,
  nonprelim_dir = file.path(chirps_dir(), "monthly"),
  save_dir = file.path(nonprelim_dir, "prelim")
)
}
\arguments{
\item{years}{years for which you want to download}

\item{months}{months for which you want to download}

\item{extent}{Spatial window for downloading}

\item{timeout_limit}{How many seconds before download is aborted.}

\item{nonprelim_dir}{Directory where the non-preliminary CHIRPS data is stored.}

\item{save_dir}{Directory where the function stores the preliminary data.}
}
\value{
nothing
}
\description{
This data becomes available earlier, but it has to be downloaded from UCSB.
The function checks whether the non-preliminary version exists and only downloads otherwise.
Annoyingly, the grid of UCBS and IRIDL are shifted against each other. Therefore this function also interpolates the UCSB data to the IRIDL grid, which makes it a bit slower.
In particular, everything will crash if you have never downloaded a non-preliminary file and try to download a preliminary one.
}
\examples{
if(interactive()){
download_chirps_prelim_aux(years = 2023, months = 10)
}

}
