% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{rel_diag}
\alias{rel_diag}
\title{Reliability Diagrams for tercile forecasts}
\usage{
rel_diag(
  dt,
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = NULL,
  pool = setdiff(dimvars(dt), by),
  binwidth = 0.05,
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing tercile forecasts}

\item{f}{column names of the prediction columns}

\item{o}{column name of the observation column}

\item{by}{column names of grouping variables. Default is to not group.}

\item{pool}{column names of pooling variables (used for the dimension check). Default is all dimvars.}

\item{binwidth}{bin width for discretizing probabilities.}

\item{dim.check}{Logical. If TRUE, the function checks whether the columns in by and pool span the entire data table.}
}
\value{
A list of gg objects which can be plotted by ggpubr::ggarrange (for example)
}
\description{
Creates reliability diagrams from a data table containing tercile forecasts
 It wraps \code{rel_diag_vec}, see \code{?rel_diag_vec} for more details.
about the output diagrams. The output format is very much inspired by Figure 5 of Mason&2018. By default, 4 diagrams are drawn,
one for each the prediction of above-, normal- and below-values, plus one for  all forecasts together.
You can provide a 'by' argument to obtain separate reliability diagrams for different values of the by-columns. E.g., when you data table contains
a column named 'season', you can set by = 'season'. Then, the function will output a list of 16 diagrams, 4 for each season.
}
\examples{
\donttest{
dt = data.table(below = c(0.5,0.3,0),
                normal = c(0.3,0.3,0.7),
                above = c(0.2,0.4,0.3),
                tc_cat = c(-1,0,0),
                lon = 1:3)
print(dt)
pp = rel_diag(dt)
if(interactive()) plot(pp)
}

}
