% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\title{Select species based on traits}
\usage{
select(t2c, constraints, t2d, obj = "FDandE", phi = 0.5,
  traitConstraint = TRUE, capd = FALSE)
}
\arguments{
\item{t2c}{Traits to constrain: A matrix of species trait values. Can be up to 2 dimensions. Organize species as rows and traits as columns.}

\item{constraints}{Trait constraints: A vector of trait values that serve as constants in the constraint equations}

\item{t2d}{Traits to diversify: A matrix of species trait values to diversify. Organize species as rows, traits as columns. Can be any dimension.}

\item{obj}{Objective function: The objective function to optimise, one of four possibilities = c("FDandE", "FD", "E", "FE").
FDandE = Rao functional diversity plus entropy; FD = Rao functional diversity only; E = entropy only; FE = functional entropy.}

\item{phi}{A parameter bounded between 0 and 1 that weights the importance of either entropy or Rao (default = 0.5)}

\item{traitConstraint}{A logical stating whether solutions should be constrained to a trait mean (default = TRUE),
when TRUE, a vector of constraints must be provided as an argument.}

\item{capd}{A logical stating whether the distance matrix should be capped at the mean distance among species (default = FALSE).}
}
\value{
Optimal solutions (i.e. probabilities) for each species.
}
\description{
This function returns a probability distribution for a species pool based on their traits and a desired trait profile (Laughlin 2014).
}
\examples{
##### 1 trait with a constraint
trait <- as.matrix(data.frame(trait=c(1,2,3)))
rownames(trait)=c(letters[1:nrow(trait)])
result1 = select(t2c=trait, constraints=c(2.5), t2d=trait, obj="FDandE", capd=TRUE)
barplot(t(result1),ylim=c(0,0.7),col="blue",names=c(c(1,2,3)),ylab="Relative abundance")

##### 1 trait and no trait constraint
result2 = select(t2c=trait, t2d=trait, obj="FDandE", traitConstraint=FALSE, capd=TRUE)
barplot(t(result2),ylim=c(0,0.7),col="blue",names=c(c(1,2,3)),ylab="Relative abundance")

##### 2 traits: Constrain trait X to value 2.5, diversify trait Y
trait.matrix <- as.matrix(cbind(traitX=c(rep(1,3),rep(2,3),rep(3,3)),
                traitY=c(rep(c(1,2,3),3))))
rownames(trait.matrix)=c(letters[1:9])
result3 = select(t2c=as.matrix(trait.matrix[,1]),constraints=c(2.5),
          t2d=as.matrix(trait.matrix[,2]),capd=TRUE,obj="FDandE")
plotprobs(result3,trait.matrix)

##### 3 traits: Constrain trait Z to value 2.5, diversify trait X and Y
traitZ <- as.matrix(data.frame(c(1,3,2,2,3,1,2,3,1)))
result4 = select(t2c=traitZ,constraints=c(2.5),t2d=trait.matrix, capd=TRUE, obj="FDandE")
plotprobs(result4,trait.matrix)

}
\references{
Laughlin, D.C. (2014) Applying trait-based models to achieve functional targets for theory-driven ecological restoration. Ecology Letters, 17, 771-784.
}

