% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensusR.R
\name{sensus.decrypt.bin.files}
\alias{sensus.decrypt.bin.files}
\title{Decrypts Sensus .bin files that were encrypted using asymmetric public/private key encryption.}
\usage{
sensus.decrypt.bin.files(data.path, is.directory = TRUE,
  recursive = TRUE, rsa.private.key.path,
  rsa.private.key.password = askpass, replace.files = FALSE)
}
\arguments{
\item{data.path}{Path to Sensus .bin data (either a file or a directory).}

\item{is.directory}{Whether or not the path is a directory.}

\item{recursive}{Whether or not to read files recursively from directory indicated by path.}

\item{rsa.private.key.path}{Path to RSA private key generated using OpenSSL.}

\item{rsa.private.key.password}{Password used to decrypt the RSA private key.}

\item{replace.files}{Whether or not to delete .bin files after they have been decrypted.}
}
\value{
None
}
\description{
Decrypts Sensus .bin files that were encrypted using asymmetric public/private key encryption.
}
\examples{
# sensus.decrypt.bin.files(data.path = "/path/to/bin/files/directory", 
#                          rsa.private.key.path = "/path/to/private.pem", 
#                          replace.files = FALSE)
}
