% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{DiffTTest}
\alias{DiffTTest}
\title{Differential expression testing using Student's t-test}
\usage{
DiffTTest(object, cells.1, cells.2, genes.use = NULL, print.bar = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{print.bar}{Print a progress bar once expression testing begins (uses pbapply to do this)}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identify differentially expressed genes between two groups of cells using
the Student's t-test
}
\examples{
pbmc_small
DiffTTest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
            cells.2 = WhichCells(object = pbmc_small, ident = 2))
}
