/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class ModularityOptimizer {
    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        long l;
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        String string;
        String string2;
        if (stringArray.length == 9) {
            string2 = stringArray[0];
            string = stringArray[1];
            n4 = Integer.parseInt(stringArray[2]);
            d = Double.parseDouble(stringArray[3]);
            n3 = Integer.parseInt(stringArray[4]);
            n2 = Integer.parseInt(stringArray[5]);
            n = Integer.parseInt(stringArray[6]);
            l = Long.parseLong(stringArray[7]);
            boolean bl2 = bl = Integer.parseInt(stringArray[8]) > 0;
            if (bl) {
                System.out.println("Modularity Optimizer version 1.3.0 by Ludo Waltman and Nees Jan van Eck");
                System.out.println();
            }
        } else {
            Console console = System.console();
            System.out.println("Modularity Optimizer version 1.3.0 by Ludo Waltman and Nees Jan van Eck");
            System.out.println();
            string2 = console.readLine("Input file name: ", new Object[0]);
            string = console.readLine("Output file name: ", new Object[0]);
            n4 = Integer.parseInt(console.readLine("Modularity function (1 = standard; 2 = alternative): ", new Object[0]));
            d = Double.parseDouble(console.readLine("Resolution parameter (e.g., 1.0): ", new Object[0]));
            n3 = Integer.parseInt(console.readLine("Algorithm (1 = Louvain; 2 = Louvain with multilevel refinement; 3 = smart local moving): ", new Object[0]));
            n2 = Integer.parseInt(console.readLine("Number of random starts (e.g., 10): ", new Object[0]));
            n = Integer.parseInt(console.readLine("Number of iterations (e.g., 10): ", new Object[0]));
            l = Long.parseLong(console.readLine("Random seed (e.g., 0): ", new Object[0]));
            bl = Integer.parseInt(console.readLine("Print output (0 = no; 1 = yes): ", new Object[0])) > 0;
            System.out.println();
        }
        if (bl) {
            System.out.println("Reading input file...");
            System.out.println();
        }
        Network network = ModularityOptimizer.readInputFile(string2, n4);
        if (bl) {
            System.out.format("Number of nodes: %d%n", network.getNNodes());
            System.out.format("Number of edges: %d%n", network.getNEdges());
            System.out.println();
            System.out.println("Running " + (n3 == 1 ? "Louvain algorithm" : (n3 == 2 ? "Louvain algorithm with multilevel refinement" : "smart local moving algorithm")) + "...");
            System.out.println();
        }
        double d2 = n4 == 1 ? d / (2.0 * network.getTotalEdgeWeight() + network.totalEdgeWeightSelfLinks) : d;
        long l2 = System.currentTimeMillis();
        Clustering clustering = null;
        double d3 = Double.NEGATIVE_INFINITY;
        Random random = new Random(l);
        for (int i = 0; i < n2; ++i) {
            double d4;
            if (bl && n2 > 1) {
                System.out.format("Random start: %d%n", i + 1);
            }
            VOSClusteringTechnique vOSClusteringTechnique = new VOSClusteringTechnique(network, d2);
            int n5 = 0;
            boolean bl3 = true;
            do {
                if (bl && n > 1) {
                    System.out.format("Iteration: %d%n", n5 + 1);
                }
                if (n3 == 1) {
                    bl3 = vOSClusteringTechnique.runLouvainAlgorithm(random);
                } else if (n3 == 2) {
                    bl3 = vOSClusteringTechnique.runLouvainAlgorithmWithMultilevelRefinement(random);
                } else if (n3 == 3) {
                    vOSClusteringTechnique.runSmartLocalMovingAlgorithm(random);
                }
                ++n5;
                d4 = vOSClusteringTechnique.calcQualityFunction();
                if (!bl || n <= 1) continue;
                System.out.format("Modularity: %.4f%n", d4);
            } while (n5 < n && bl3);
            if (d4 > d3) {
                clustering = vOSClusteringTechnique.getClustering();
                d3 = d4;
            }
            if (!bl || n2 <= 1) continue;
            if (n == 1) {
                System.out.format("Modularity: %.4f%n", d4);
            }
            System.out.println();
        }
        long l3 = System.currentTimeMillis();
        if (bl) {
            if (n2 == 1) {
                if (n > 1) {
                    System.out.println();
                }
                System.out.format("Modularity: %.4f%n", d3);
            } else {
                System.out.format("Maximum modularity in %d random starts: %.4f%n", n2, d3);
            }
            System.out.format("Number of communities: %d%n", clustering.getNClusters());
            System.out.format("Elapsed time: %d seconds%n", Math.round((double)(l3 - l2) / 1000.0));
            System.out.println();
            System.out.println("Writing output file...");
            System.out.println();
        }
        ModularityOptimizer.writeOutputFile(string, clustering);
    }

    private static Network readInputFile(String string, int n) throws IOException {
        Network network;
        int n2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n3 = 0;
        while (bufferedReader.readLine() != null) {
            ++n3;
        }
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        int n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            String[] stringArray = bufferedReader.readLine().split("\t");
            nArray[n2] = Integer.parseInt(stringArray[0]);
            if (nArray[n2] > n4) {
                n4 = nArray[n2];
            }
            nArray2[n2] = Integer.parseInt(stringArray[1]);
            if (nArray2[n2] > n4) {
                n4 = nArray2[n2];
            }
            dArray[n2] = stringArray.length > 2 ? Double.parseDouble(stringArray[2]) : 1.0;
        }
        int n5 = n4 + 1;
        bufferedReader.close();
        int[] nArray3 = new int[n5];
        for (n4 = 0; n4 < n3; ++n4) {
            if (nArray[n4] >= nArray2[n4]) continue;
            int n6 = nArray[n4];
            nArray3[n6] = nArray3[n6] + 1;
            int n7 = nArray2[n4];
            nArray3[n7] = nArray3[n7] + 1;
        }
        int[] nArray4 = new int[n5 + 1];
        int n8 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            nArray4[n4] = n8;
            n8 += nArray3[n4];
        }
        nArray4[n5] = n8;
        int[] nArray5 = new int[n8];
        double[] dArray2 = new double[n8];
        Arrays.fill(nArray3, 0);
        for (n4 = 0; n4 < n3; ++n4) {
            if (nArray[n4] >= nArray2[n4]) continue;
            n2 = nArray4[nArray[n4]] + nArray3[nArray[n4]];
            nArray5[n2] = nArray2[n4];
            dArray2[n2] = dArray[n4];
            int n9 = nArray[n4];
            nArray3[n9] = nArray3[n9] + 1;
            n2 = nArray4[nArray2[n4]] + nArray3[nArray2[n4]];
            nArray5[n2] = nArray[n4];
            dArray2[n2] = dArray[n4];
            int n10 = nArray2[n4];
            nArray3[n10] = nArray3[n10] + 1;
        }
        if (n == 1) {
            network = new Network(n5, nArray4, nArray5, dArray2);
        } else {
            double[] dArray3 = new double[n5];
            Arrays.fill(dArray3, 1.0);
            network = new Network(n5, dArray3, nArray4, nArray5, dArray2);
        }
        return network;
    }

    private static void writeOutputFile(String string, Clustering clustering) throws IOException {
        int n = clustering.getNNodes();
        clustering.orderClustersByNNodes();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            bufferedWriter.write(Integer.toString(clustering.getCluster(i)));
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }
}

